<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman render label layout
 *
 * @version 4.2.6
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2023 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

defined('JPATH_BASE') or die;

extract($displayData);

/**
 * Layout variables
 * ---------------------
 * 	$text         : (string)  The label text
 * 	$for          : (string)  The id of the input this label is for
 * 	$required     : (boolean) True if a required field
 * 	$classes      : (array)   A list of classes
 */

$id    = $for . '-lbl';
$forAttr = '';

if ($required)
{
	$classes[] = 'required';
}

if(!isset($displayData['field']->skipLabelFor) || $displayData['field']->skipLabelFor !== true)
{
	$forAttr = 'for="' . $for . '"';
}
?>
<label id="<?php echo $id; ?>" <?php echo $forAttr; ?><?php if (!empty($classes)) echo ' class="' . implode(' ', $classes) . '"'; ?>>
	<?php echo $text; ?><?php if ($required) : ?><span class="star" aria-hidden="true">&#160;*</span><?php endif; ?>
</label>
