<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman all mailinglists default template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

if (version_compare(JVERSION,'3.0.0','>=')) {
	JHtml::_('bootstrap.tooltip');
	JHtml::_('formbehavior.chosen', 'select');
}
else {
	JHTML::_('behavior.tooltip');
}

JHtml::_('behavior.multiselect');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

?>

<script type="text/javascript">
/* <![CDATA[ */
	Joomla.submitbutton = function (pressbutton) {
		
		if (pressbutton == 'archive') {
			ConfirmArchive = confirm("<?php echo JText::_('COM_BWPOSTMAN_ML_CONFIRM_ARCHIVE' , true); ?>");
			if (ConfirmArchive == true) {
				submitform(pressbutton);
			} else {
				return;
			}
		} else {
			submitform(pressbutton);		
		} 

	}
/* ]]> */	
</script>

<div id="bwp_view_lists">
	<form action="<?php echo JRoute::_('index.php?option=com_bwpostman&view=mailinglists'); ?>" method="post" name="adminForm" id="adminForm" class="form-inline">
		<fieldset id="filter-bar" class="well well-small">
			<div class="filter-search fltlft pull-left">
				<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('SEARCH'); ?></label>
				<select name="filter_search_filter" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->filtersearch, 'value', 'text', $this->state->get('filter.search_filter')) ; ?>
				</select>
				<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('COM_BWPOSTMAN_FILTER_SEARCH_DESC'); ?>" />
				
				<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
				<button type="button" class="btn" onclick="document.getElementById('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			</div>
			<div class="filter-select fltrt pull-right">
				<select name="filter_published" class="inputbox" onchange="this.form.submit()">
					<option value=""><?php echo JText::_('JOPTION_SELECT_PUBLISHED');?></option>
					<?php echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions', array('trash' => 0, 'archived' => 0)), 'value', 'text', $this->state->get('filter.published'), true);?>
				</select>
				
				<select name="filter_access" class="inputbox" onchange="this.form.submit()">
					<option value=""><?php echo JText::_('JOPTION_SELECT_ACCESS');?></option>
					<?php echo JHtml::_('select.options', JHtml::_('access.assetgroups'), 'value', 'text', $this->state->get('filter.access'));?>
				</select>
		        <?php
		        if (version_compare(JVERSION,'3.0.0','>=')) {
		          echo $this->pagination->getLimitBox();
				}
		        ?>
			</div>
		</fieldset>

	    <div class="row-fluid">
			<table class="adminlist table table-striped">
				<thead>
					<tr>
						<th width="30" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'NUM', 'a.id', $listDirn, $listOrder); ?></th>
						<th width="30" nowrap="nowrap"><input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" /></th>
						<th width="250" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_ML_TITLE', 'a.title', $listDirn, $listOrder); ?></th>
						<th nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_ML_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?></th>
						<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'PUBLISHED', 'a.published', $listDirn, $listOrder); ?></th>
						<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'ACCESS_LEVEL', 'access_level', $listDirn, $listOrder); ?></th>
						<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_ML_SUB_NUM', 'subscribers', $listDirn, $listOrder); ?></th>
					</tr>
				</thead>
				<tfoot>
					<tr>
						<td colspan="7"><?php echo $this->pagination->getListFooter(); ?></td>
					</tr>
				</tfoot>
				<tbody>
				<?php
					if (count($this->items) > 0) {
						foreach ($this->items as $i => $item) : 
						$canCheckin	= $user->authorise('core.manage',		'com_bwpostman') || $item->checked_out == $userId || $item->checked_out == 0;
						$canEdit	= $user->authorise('core.edit',			'com_bwpostman.mailinglist.'.$item->id);
						$canEditOwn	= $user->authorise('core.edit.own',		'com_bwpostman.mailinglist.'.$item->id) && $item->created_by == $userId;
						$canChange	= $user->authorise('core.edit.state',	'com_bwostman.mailinglist.'.$item->id) && $canCheckin;
						?>
						<tr class="row<?php echo $i % 2; ?>">
							<td align="center"><?php echo $item->id; ?></td>
							<td align="center"><?php echo JHtml::_('grid.id', $i, $item->id); ?></td>
							<td>
								<?php if ($item->checked_out) : ?>
									<?php echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'mailinglists.', $canCheckin); ?>
								<?php endif; ?>
								<?php if ($canEdit || $canEditOwn) : ?>
									<a href="<?php echo JRoute::_('index.php?option=com_bwpostman&task=mailinglist.edit&id='. $item->id);?>"><?php echo $this->escape($item->title); ?></a>
								<?php else : ?>
									<?php echo $this->escape($item->title); ?>
								<?php endif; ?>
							</td>
							<td><?php echo $item->description; ?></td>
							<td align="center"><?php echo JHTML::_('jgrid.published', $item->published, $i, 'mailinglists.', $canChange, 'cb'); ?>
							<td><?php echo $this->escape($item->access_level); ?></td>
							<td align="center"><?php echo $item->subscribers; ?></td>
						</tr>
						<?php endforeach;
						}
						else { ?>
							<tr class="row1">
								<td colspan="7"><strong><?php echo JText::_('COM_BWPOSTMAN_NO_DATA'); ?></strong></td>
							</tr><?php
						}
				?>
				</tbody>
			</table>
		
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
			<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
			<?php echo JHTML::_('form.token'); ?>
	    </div>
		<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
	</form>
</div>
