<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman single newsletter default 0 template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

if (version_compare(JVERSION,'3.0.0','>=')) {
	JHtml::_('bootstrap.tooltip');
//	JHtml::_('formbehavior.chosen', 'select');
}
else {
	JHTML::_('behavior.tooltip');
}

JHtml::_('behavior.multiselect');
JHTML::_('behavior.keepalive');

//Load tabs behavior for the Tabs
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/bwtabs.php');

$app	= JFactory::getApplication();
$tab	= $app->getUserState('com_bwpostman.newsletters.tab' . $this->item->id, 'basic');

switch ($tab) {
	case 'html'		: $tab_offset	= 1;
		break;
	case 'text'		: $tab_offset	= 2;
		break;
	case 'preview'	: $tab_offset	= 3;
		break;
	case 'send'		: $tab_offset	= 4;
		break;
	default:
	case 'basic'	: $tab_offset	= 0;
		break;
}
$tab_cookie	= false;

$tab_options = array(
    'onActive' => 'function(title, description){
        description.setStyle("display", "block");
        title.addClass("open").removeClass("closed");
    }',
    'onBackground' => 'function(title, description){
        description.setStyle("display", "none");
        title.addClass("closed").removeClass("open");
    }',
    'startOffset' => $tab_offset,  // 0 starts on the first tab, 1 starts the second, etc...
    'useCookie' => $tab_cookie, // note the quotes around true, since it must be a string. But if you put false there, you must not use qoutes otherwise JHtmlTabs will handle it as true
);
?>

<script type="text/javascript">
/* <![CDATA[ */

// Method to check and compare the selected content from the database and the selected content from the form
function checkSelectedContent(selected_content_new, selected_content_old, content_exists) {
//alert('Sel-Content neu:' + JSON.stringify(selected_content_new));
//alert('Sel-Content neu:' + selected_content_new.toSource());
	// Get the selected content from the database and split the string into an array but only if there is not the content ''
	var selected_content_oldArray = [];
	if (selected_content_old.value != '') {
		selected_content_oldArray = selected_content_old.value.split(",");
	}

	// Get the selected content from the form and store it into an array
	var selected_content_newArray = [];
	for (var i=0; i<selected_content_new.options.length; i++) {
		
		var o = selected_content_new.options[i];
//		alert('Neue Inhalte:\n' + o.value);
		o.selected = true;
		selected_content_newArray[i] = o.value;
	}

	// Check the selected content from the database and the selected content from the form only if there is already a html- or text-version of the newsletter
	if (content_exists.value == 1) {

		// Check the number of entries and compare them
		if (selected_content_newArray.length != selected_content_oldArray.length) { // The lenghts of the arrays are not equal
			confirmAddContent = confirm("<?php echo JText::_('COM_BWPOSTMAN_NL_CONFIRM_ADD_CONTENT', true); ?>");
			if (confirmAddContent == true) {
				if (selected_content_new.options.length == 0) {
					// content changed but no content selected
					document.adminForm.add_content.value = -1;
				}
				else {
					document.adminForm.add_content.value = 1;
				}
				return true;
			} 
			else {
				document.adminForm.add_content.value = 0;
		        return false;
			}
		} 
		else { // The lenghts of the arrays are equal

			// Compare the entries of the arrays
			for (var j=0; j<selected_content_newArray.length; j++) {

				if (selected_content_newArray[j] != selected_content_oldArray[j]) { // The values are not equal
					confirmAddContent = confirm("<?php echo JText::_('COM_BWPOSTMAN_NL_CONFIRM_ADD_CONTENT', true); ?>");
					if (confirmAddContent == true) {
						document.adminForm.add_content.value = 1;
				        return true;
					} 
					else {
						document.adminForm.add_content.value = 0;
				        return false;
					}
					return;
				}
			}
			// The values of both arrays are equal, so we doesn't have to do anything
			if (selected_content_new.options.length == 0) {
				// content exists but no content selected
				document.adminForm.add_content.value = -1;
			}
			else {
				document.adminForm.add_content.value = 0;
			}
			return true;
		}
	} 
	else { // There is no selected content and no old html- or text-version, but may be possibly new entered data in html- or text-editor, so let's save, model will check for content
		// Store changes only if some content is selected
		if (selected_content_newArray.length > 0) {
			document.adminForm.add_content.value = 1;
			return true;
		}
		else {
			// no content selected
			document.adminForm.add_content.value = -1;
			document.adminForm.selected_content_old.value = -1;
			return true;
		}
	}
}

Joomla.submitbutton = function (pressbutton) {
//	alert('Pressbutton: ' + pressbutton);
		var form = document.adminForm;
		if (pressbutton == 'newsletter.cancel') {
			submitform(pressbutton);
			return;
		} 

		if (pressbutton == 'newsletter.back') {
			form.task.value = 'back';
			submitform(pressbutton);
			return;
		}

		if (pressbutton == 'newsletter.apply') {
//			alert('Task apply');
			if (checkSelectedContent(document.adminForm['jform_selected_content'],document.adminForm['selected_content_old'], document.adminForm['content_exists']) == true) {
			document.adminForm.task.setAttribute('value','newsletter.apply');
			submitform(pressbutton);
			}
			return;
		} 

		if (pressbutton == 'newsletter.save') {
			if (checkSelectedContent(document.adminForm['jform_selected_content'],document.adminForm['selected_content_old'], document.adminForm['content_exists']) == true) {
			document.adminForm.task.setAttribute('value','newsletter.save');
			submitform(pressbutton);
			}
			return;
		} 

		if (pressbutton == 'newsletter.sendmail') {
			confirmSendNl = confirm("<?php echo JText::_('COM_BWPOSTMAN_NL_CONFIRM_SENDING', true); ?>");
			if (confirmSendNl == true) {
			document.adminForm.task.setAttribute('value','newsletter.sendmail');
			submitform(pressbutton);
			}
		} 

		if (pressbutton == 'newsletter.sendtestmail') {
			confirmSendNl = confirm("<?php echo JText::_('COM_BWPOSTMAN_NL_CONFIRM_SENDING', true); ?>");
			if (confirmSendNl == true) {
			document.adminForm.task.setAttribute('value','newsletter.sendmail');
			submitform(pressbutton);
			}
		} 

//		submitform(pressbutton);
	}

window.addEvent('domready', function() {
	$(document.body).getElements('#bwpostman_newsletter_tabs a').addEvents({
		'click': function(){ 
//			alert('test');
		}
	});
});

/* ]]> */
</script>

<div id="bwp_view_lists" class="well well-small">
	<?php
		if ($this->queueEntries) {
			JFactory::getApplication()->enqueueMessage(JText::_('COM_BWPOSTMAN_ENTRIES_IN_QUEUE'), 'warning');
 		}
	?>
	<form action="<?php echo JRoute::_('index.php?option=com_bwpostman&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm">
		<?php
			echo JHtmlBwTabs::start('bwpostman_newsletter_tabs', $tab_options);
	
			// Start Tab basic
			echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_NL_STP1'), 'basic', 
					" 
						checkSelectedContent(document.adminForm['jform_selected_content'],document.adminForm['selected_content_old'], document.adminForm['content_exists']);
						document.adminForm.tab.setAttribute('value','basic');
						document.adminForm.task.setAttribute('value','newsletter.changeTab');
						document.adminForm.submit();
					");	
			echo $this->loadTemplate('basic');
	
			// Start Tab HTML
			echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_NL_STP2'), 'html', 
					" 
						checkSelectedContent(document.adminForm['jform_selected_content'],document.adminForm['selected_content_old'], document.adminForm['content_exists']);
						document.adminForm.tab.setAttribute('value','html');
						document.adminForm.task.setAttribute('value','newsletter.changeTab');
						document.adminForm.submit();
					");	
			echo $this->loadTemplate('html');
	
			// Start Tab Text
			echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_NL_STP3'), 'text', 
					"
						checkSelectedContent(document.adminForm['jform_selected_content'],document.adminForm['selected_content_old'], document.adminForm['content_exists']);
						document.adminForm.tab.setAttribute('value','text');
						document.adminForm.task.setAttribute('value','newsletter.changeTab');
						document.adminForm.submit();
					");	
			echo $this->loadTemplate('text');
	
			// Start Tab Preview
			echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_NL_STP4'), 'preview', 
					"
						checkSelectedContent(document.adminForm['jform_selected_content'],document.adminForm['selected_content_old'], document.adminForm['content_exists']);
						document.adminForm.tab.setAttribute('value','preview');
						document.adminForm.task.setAttribute('value','newsletter.changeTab');
						document.adminForm.submit();
					");	
			echo $this->loadTemplate('preview');
	
			// Start Tab send
			echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_NL_STP5'), 'send', 
					"
						checkSelectedContent(document.adminForm['jform_selected_content'],document.adminForm['selected_content_old'], document.adminForm['content_exists']);
						document.adminForm.tab.setAttribute('value','send');
						document.adminForm.task.setAttribute('value','newsletter.changeTab');
						document.adminForm.submit();
					");	
			echo $this->loadTemplate('send');
	
			echo JHtmlBwTabs::end();
			
		?>
		<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
		
		<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
		<input type="hidden" name="asset_id" value="<?php echo $this->item->asset_id; ?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" id="layout" name="layout" value="edit" /><!-- value never changes -->
		<input type="hidden" name="tab" value="" /><!-- value can change if one clicks on another tab -->
		<input type="hidden" name="add_content" value="" />
		<input type="hidden" name="selected_content_old" value="<?php echo $this->selected_content_old; ?>" />
		<input type="hidden" name="content_exists" value="<?php echo $this->content_exists; ?>" />
		<?php echo JHTML::_('form.token'); ?>
	</form>
</div>

