<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman single subscriber export template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Load the tooltip behavior for the notes
JHTML::_('behavior.tooltip');

?>

<script type="text/javascript">
/* <![CDATA[ */
//-----------------------------------------------------------------------------
//http://www.mattkruse.com/javascript/selectbox/source.html
//-----------------------------------------------------------------------------
	function selectAllOptions(obj) {
		for (var i=0; i<obj.options.length; i++) {
			obj.options[i].selected = true;
		}
	}


//-----------------------------------------------------------------------------
//in Anlehnung an: http://www.plus2net.com/javascript_tutorial/list-remove.php
//-----------------------------------------------------------------------------
	function removeOptions(selectbox)
	{
		var i;
		
		for(i=selectbox.options.length-1;i>=0;i--) {
			if(selectbox.options[i].selected){
				selectbox.remove(i);
			}
		}
	}

//-----------------------------------------------------------------------------
//http://javascript.internet.com/forms/select-box-with-options.html
//-----------------------------------------------------------------------------
	function moveUp(element) // Method to move an item up
	{
		for(i = 0; i < element.options.length; i++) {
			if(element.options[i].selected == true) {
		   		if(i != 0) {
			    	var temp = new Option(element.options[i-1].text,element.options[i-1].value);
				    var temp2 = new Option(element.options[i].text,element.options[i].value);
				    element.options[i-1] = temp2;
				    element.options[i-1].selected = true;
				    element.options[i] = temp;
		   		}
		 	}
		}
	}
	
	function moveDown(element) // Method to move an item down
	{
		for(i = (element.options.length - 1); i >= 0; i--) {
			if(element.options[i].selected == true) {
		   		if(i != (element.options.length - 1)) {
		     		var temp = new Option(element.options[i+1].text,element.options[i+1].value);
		     		var temp2 = new Option(element.options[i].text,element.options[i].value);
		     		element.options[i+1] = temp2;
		     		element.options[i+1].selected = true;
		     		element.options[i] = temp;
		   		}
		 	}
		}
	}

	function check() // Method to check if the user didn't delete all items in the select box
	{
		var count_export_fields = document.getElementById('export_fields').length;
	
		if (count_export_fields <= 0) {
		alert ("<?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_ERROR_NO_EXPORTFIELDS', true); ?>");
		return 0;
		}
		return 1;
	}

//-------------------------------------------------------------------------------------
//http://www.easywayserver.com/blog/enable-disable-radio-button-text-box-in-javascript
//-------------------------------------------------------------------------------------
	
 function enable_disable() // Method to enable and disable special input fields
 {

  for(var i=0;i<document.adminForm.elements.length;i++)
  {
    if(document.adminForm.elements[i].name=="fileformat")
    {
	 if(document.adminForm.elements[i].getAttribute('value')=="csv")
     {
       if(document.adminForm.elements[i].checked==true){
        document.adminForm.delimiter.disabled=false;
        document.adminForm.enclosure.disabled=false;

		document.adminForm.status0.disabled=false;
		document.adminForm.status1.disabled=false;
		document.adminForm.status9.disabled=false;		
		document.adminForm.archive0.disabled=false;
		document.adminForm.archive1.disabled=false;	
        document.adminForm.export_fields.disabled=false;
        document.adminForm.submitbutton.disabled=false;
 		document.adminForm.upbutton.disabled=false;
  		document.adminForm.downbutton.disabled=false;
  		document.adminForm.removebutton.disabled=false;        
       }
     }
     else if(document.adminForm.elements[i].getAttribute('value')=="xml")
     {
       if(document.adminForm.elements[i].checked==true){
        document.adminForm.delimiter.disabled=true;
        document.adminForm.enclosure.disabled=true;

		document.adminForm.status0.disabled=false;
		document.adminForm.status1.disabled=false;
		document.adminForm.status9.disabled=false;		
		document.adminForm.archive0.disabled=false;
		document.adminForm.archive1.disabled=false;
        document.adminForm.export_fields.disabled=false;
        document.adminForm.submitbutton.disabled=false;
 		document.adminForm.upbutton.disabled=false;
  		document.adminForm.downbutton.disabled=false;
  		document.adminForm.removebutton.disabled=false;
       }
     }
    }
  }
 }
 /* ]]> */
</script>

<?php
	$jinput	= JFactory::getApplication()->input;
	if (version_compare(JVERSION,'3.0.0','>=')) {
		JHtml::_('bootstrap.tooltip');
		$image = '<i class="icon-info"></i>';
	}
	else {
		JHTML::_('behavior.tooltip');
		$image = JHTML::_('image', 'administrator/templates/'. $this->template .'/images/menu/icon-16-info.png', JText::_('COM_BWPOSTMAN_NOTES'));
	}
	$option	= $jinput->getCmd('option');
?>

<form action="<?php echo $this->request_url_raw; ?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
	<fieldset class="adminform">
		<legend><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_SUBS'); ?></legend>
		<div class="well well-small">
			<table class="admintable <?php if (version_compare(JVERSION,'3.0.0','>=')) { echo 'import';} else { echo 'bwptable';} ?>">
				<tr class="bwptable">
					<td align="right" class="key">
						<span class="bwplabel"><?php echo JText::_('COM_BWPOSTMAN_SUB_FILEFORMAT'); ?></span>
						<span class="editlinktip hasTip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_FILEFORMAT_NOTE'); ?>"><?php echo $image; ?></span>
					</td>
					<td class="bwptable"><div class="bwpmailformat"><?php echo $this->lists['fileformat']; ?></div></td>
				</tr>
				<tr class="bwptable">
					<td align="right" class="key">
						<span class="bwplabel"><?php echo JText::_('COM_BWPOSTMAN_SUB_DELIMITER'); ?></span>
						<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_DELIMITER_NOTE'); ?>"><?php echo $image; ?></span>
					</td>
					<td><?php echo $this->lists['delimiter'];?></td>
				</tr>
				<tr class="bwptable">
					<td align="right" class="key">
						<span class="bwplabel"><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_ENCLOSURE'); ?></span>
						<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_ENCLOSURE_NOTE'); ?>"><?php echo $image; ?></span>
					</td>
					<td><?php echo $this->lists['enclosure'];?></td>
				</tr>
				<tr class="bwptable">
					<td align="right" class="key"><span class="bwplabel"><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_GROUPS'); ?></span>
						<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_GROUPS_NOTE'); ?>"><?php echo $image; ?></span>
					</td>
					<td class="bwptable">
						<div class="bwpmailformat">
							<?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_STATUS'); ?>
							<p><input type="checkbox" id="status1" name="status1" value="1" disabled="disabled" /><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_CONFIRMED'); ?></p>
							<p><input type="checkbox" id="status0" name="status0" value="1" disabled="disabled" /><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_UNCONFIRMED'); ?></p>
							<p><input type="checkbox" id="status9" name="status9" value="1" disabled="disabled" /><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_TEST'); ?></p>
							<br />
							<?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_ARCHIVE'); ?><br />
							<p><input type="checkbox" id="archive0" name="archive0" value="1" disabled="disabled" /><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_UNARCHIVED'); ?></p>
							<p><input type="checkbox" id="archive1" name="archive1" value="1" disabled="disabled" /><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_ARCHIVED'); ?></p>
						</div>
					</td>
				</tr>
			</table>
	
			<table class="admintable <?php if (version_compare(JVERSION,'3.0.0','>=')) { echo 'import';} else { echo 'bwptable';} ?>">
				<tr>
					<td width="150" align="right" class="key"><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_FIELDS'); ?><br />
						<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_FIELDS_NOTE'); ?>"><?php echo $image; ?></span>
					</td>
					<td valign="top" width="280"><?php echo $this->lists['export_fields']; ?><br />
						<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_MOVE_UP_NOTE');?>">
							<input class="btn btn-small" type="button" name="upbutton" onclick="moveUp(document.getElementById('export_fields'));" value="<?php echo JText::_('COM_BWPOSTMAN_SUB_MOVE_UP'); ?>" /> 
						</span>
						<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_MOVE_DOWN_NOTE');?>">
							<input class="btn btn-small" type="button" name="downbutton" onclick="moveDown(document.getElementById('export_fields'));" value="<?php echo JText::_('COM_BWPOSTMAN_SUB_MOVE_DOWN'); ?>" />
						</span>
						<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_REMOVE_SELECTED_NOTE');?>">
							<input class="btn btn-small" type="button" name="removebutton" onclick="removeOptions(export_fields);" value="<?php echo JText::_('COM_BWPOSTMAN_SUB_REMOVE_SELECTED'); ?>" />
						</span>
					</td>
					<td>&nbsp;</td>
					<td valign="top"><?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_FIELDS_ANNOTATION'); ?></td>
				</tr>
			</table>
			
			<table class="admintable bwptable">
				<tr>
					<td width="150" align="center" class="key">
						<input class="btn btn-success" type="button" name="submitbutton" disabled="disabled" 
								onclick="if(check()){selectAllOptions(document.adminForm['export_fields[]']);Joomla.submitbutton('subscribers.export');}" value="<?php echo JText::_('COM_BWPOSTMAN_SUB_EXPORT_BUTTON'); ?>"
						/>
					</td>
				</tr>
			</table>
		</div>
	</fieldset>
	
	<input type="hidden" name="task" value="export" />
	<input type="hidden" name="controller" value="subscribers" />
	<input type="hidden" name="option" value="<?php echo $option; ?>" />
	<?php echo JHTML::_('form.token'); ?>
</form>

<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
