<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman single subscriber import 0 template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Load the tooltip behavior for the notes
JHTML::_('behavior.tooltip');

// Keep session alive while importing
JHTML::_('behavior.keepalive');
?>

<script type="text/javascript">
/* <![CDATA[ */
//-------------------------------------------------------------------------------------
//http://www.easywayserver.com/blog/enable-disable-radio-button-text-box-in-javascript
//-------------------------------------------------------------------------------------

 function enable_disable()
 {

  // Initialize form with empty field
  document.adminForm.importfile.disabled=false;
  document.adminForm.importfile.value="";

  for(var i=0;i<document.adminForm.elements.length;i++)
  {
    if(document.adminForm.elements[i].name=="fileformat")
    {
	 if(document.adminForm.elements[i].getAttribute('value')=="csv")
     {
       if(document.adminForm.elements[i].checked==true){
        document.adminForm.importfile.disabled=false;
        document.adminForm.delimiter.disabled=false;
        document.adminForm.enclosure.disabled=false;
        document.adminForm.caption.disabled=false;

        document.adminForm.submitbutton.disabled=false;
       }
     }
     else if(document.adminForm.elements[i].getAttribute('value')=="xml")
     {
       if(document.adminForm.elements[i].checked==true){
        document.adminForm.importfile.disabled=false;
        document.adminForm.delimiter.disabled=true;
        document.adminForm.enclosure.disabled=true;
        document.adminForm.caption.disabled=true;

        document.adminForm.submitbutton.disabled=false;
       }
     }
    }
  }
 }

 /* ]]> */
</script>

<?php
	$jinput	= JFactory::getApplication()->input;
	if (version_compare(JVERSION,'3.0.0','>=')) {
		JHtml::_('bootstrap.tooltip');
		$image = '<i class="icon-info"></i>';
	}
	else {
		JHTML::_('behavior.tooltip');
		$image = JHTML::_('image', 'administrator/templates/'. $this->template .'/images/menu/icon-16-info.png', JText::_('COM_BWPOSTMAN_NOTES'));
	}
	$option = $jinput->getCmd('option');
?>

<form action="<?php echo $this->request_url; ?>" method="post" name="adminForm" id="adminForm" enctype="multipart/form-data">
	<fieldset class="adminform">
		<legend><?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_STP1'); ?></legend>
		<div class="well well-small">
			<div class="row-fluid">
			    <table class="admintable bwptable<?php if (version_compare(JVERSION,'3.0.0','>=')) echo ' import'; ?>">
					<tr class="bwptable">
						<td width="250" align="right" class="key">
							<span class="bwplabel"><?php echo JText::_('COM_BWPOSTMAN_SUB_FILEFORMAT'); ?></span>
							<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_FILEFORMAT_NOTE'); ?>"><?php echo $image; ?></span>
						</td>
						<td class="bwptable">
							<div class="bwpmailformat">
								<?php echo $this->lists['fileformat']; ?>
							</div>
						</td>
					</tr>
					<tr>
						<td align="right" class="key">
							<span class="bwplabel"><?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_FILE'); ?></span>
							<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_FILE_NOTE'); ?>"><?php echo $image; ?></span>
						</td>
						<td>
							<input type="file" name="importfile" id="importfile" <?php if (empty($this->import['fileformat'])) echo ' disabled="disabled"'; ?> />
						</td>
					</tr>
					<tr>
						<td align="right" class="key">
							<span class="bwplabel"><?php echo JText::_('COM_BWPOSTMAN_SUB_DELIMITER'); ?></span>
							<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_DELIMITER_NOTE'); ?>"><?php echo $image; ?></span>
						</td>
						<td><?php echo $this->lists['delimiter'];?></td>
					</tr>
					<tr>
						<td align="right" class="key">
							<span class="bwplabel"><?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_ENCLOSURE'); ?></span>
							<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_ENCLOSURE_NOTE'); ?>"><?php echo $image; ?></span>
						</td>
						<td><?php echo $this->lists['enclosure'];?></td>
					</tr>
					<tr>
						<td align="right" class="key">
							<span class="bwplabel"><?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_CAPTION'); ?></span>
							<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_CAPTION_NOTE'); ?>"><?php echo $image; ?></span>
						</td>
						<td>
							<input type="checkbox" id="caption" name="caption"
								<?php if (isset ($this->import['caption'])) { if ($this->import['caption'] == 1) echo "checked"; } ?>
								<?php if ((empty($this->import['fileformat'])) || ($this->import['fileformat'] == 'xml')) echo ' disabled="disabled"'; ?>
							/>
						</td>
					</tr>
					<tr>
						<td width="250" align="center" class="key">
							<input type="button" class="btn btn-success" name="submitbutton"
								<?php if (empty($this->import['fileformat'])) echo ' disabled="disabled"'; ?>
										onclick="Joomla.submitbutton('subscribers.prepareImport');" value="<?php echo JText::_('COM_BWPOSTMAN_SUB_IMPORT_BUTTON'); ?>" 
							/>
						</td>
					</tr>
				</table>
			</div>
		</div>
	</fieldset>
	
	<input type="hidden" name="task" value="prepareImport" />
	<input type="hidden" name="controller" value="subscribers" />
	<input type="hidden" name="option" value="<?php echo $option; ?>" />
	<?php echo JHTML::_('form.token'); ?>
</form>

<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
