<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman installer.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

use Joomla\Registry\Format\Json;

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

class com_bwpostmanInstallerScript
{
	/** @var int asset_id */
	var $release = null;

	/**
	 * Constructor
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 */
	/*	public function __constructor(JAdapterInstance $adapter)
	 {

	}
	*/

	/**
	 * Executes additional installation processes
	 */
	private function _bwpostman_install()
	{
	}
	
	/**
	 * Called before any type of action
	 *
	 * @param   string  			$type		Which action is happening (install|uninstall|discover_install|update)
	 * @param   JAdapterInstance	$parent		The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	
	public function preflight($type, JAdapterInstance $parent)
	{
		$app 		= JFactory::getApplication ();
		$jversion	= new JVersion();
		$jInstall	= new JInstaller('com_bwpostman');
		
		// Get component manifest file version
		$this->release = $parent->get("manifest")->version;
		
		// Manifest file minimum Joomla version
		$this->minimum_joomla_release = $parent->get("manifest")->attributes()->version;

		// abort if the current Joomla release is older
		if(version_compare($jversion->getShortVersion(), $this->minimum_joomla_release, 'lt')) {
			$app->enqueueMessage(JText::sprintf('COM_BWPOSTMAN_INSTALL_ERROR_JVERSION', $this->minimum_joomla_release), 'error');
			return false;
		}
		
		if(floatval(phpversion()) < 5)
		{
			$app->enqueueMessage(JText::_('COM_BWPOSTMAN_USES_PHP5'), 'error');
			return false;
		}
		
		// abort if the component being installed is not newer than the currently installed version
		if ($type == 'update') {
			$oldRelease = $this->getManifestVar('version');
			$app->setUserState('com_bwpostman.update.oldRelease', $oldRelease);
			
			if (version_compare( $this->release, $oldRelease, 'lt')) {
				$app->enqueueMessage(JText::sprintf('COM_BWPOSTMAN_INSTALL_ERROR_INCORRECT_VERSION_SEQUENCE', $oldRelease, $this->release), 'error');
				return false;
			}
			
			// delete existing files in frontend and backend to prevent conflicts with previous relicts
			jimport('joomla.filesystem.folder');
			$admin_path	= JPATH_ADMINISTRATOR . '/components/com_bwpostman';
			$site_path	= JPATH_SITE . '/components/com_bwpostman';

			if (JFolder::exists($admin_path) === true) {
				JFolder::delete($admin_path);
			}

			if (JFolder::exists($site_path) === true) {
				JFolder::delete($site_path);
			}
		}
		
		$db	= JFactory::getDBO();
		$query	= $db->getQuery(true);
		
		$query->select($db->quoteName('params'));
		$query->from($db->quoteName('#__extensions'));
		$query->where($db->quoteName('element') . " = " . $db->quote('com_bwpostman'));
		
		$db->SetQuery($query);
		$params_default = $db->loadResult();
		$app->setUserState('com_bwpostman.install.params', $params_default);
				
	}
	
	
	/**
	 * Called after any type of action
	 *
	 * @param   string  			$type		Which action is happening (install|uninstall|discover_install)
	 * @param   JAdapterInstance	$parent		The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	
	public function postflight($type, JAdapterInstance $parent)
	{
		if ($type == 'install') {
			// Set BwPostman default settings in the extensions table at install
			$this->_setDefaultParams();
		}
		
		if ($type == 'update') {
			require_once (JPATH_ADMINISTRATOR.'/components/com_bwpostman/helpers/tablehelper.php');
			
			$app 		= JFactory::getApplication ();
			$oldRelease	= $app->getUserState('com_bwpostman.update.oldRelease', '');

			if (version_compare($oldRelease, '1.0.1', 'lt')) BwPostmanTableHelper::adjustMLAccess();
			
			// check all tables of BwPostman
			// first save all tables
			echo '<br /><br /><div class="well">';
			echo '<h1>' . JText::_('COM_BWPOSTMAN_MAINTENANCE_SAVE_TABLES') . '</h1>';
			BwPostmanTableHelper::saveTables(true);
			
			// then make the checks (function repairs tables automatically)
			echo '<br /><br /><h1>' . JText::_('COM_BWPOSTMAN_MAINTENANCE_CHECK_TABLES') . '</h1>';
			$check_res	= BwPostmanTableHelper::checkTables();
			echo '</div>';
		}
	}
	
	
	/**
	 * Called on installation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	
	public function install(JAdapterInstance $adapter)
	{
		$this->_bwpostman_install();
		$this->showFinished(false);
	}
	
	
	/**
	 * Called on update
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	
	public function update(JAdapterInstance $adapter)
	{
		$this->_bwpostman_install();
		$this->showFinished(true);
	}
	
	
	/**
	 * Called on uninstallation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 */
	
	public function uninstall(JAdapterInstance $adapter)
	{
//		echo "<div>BwPostman is now removed from your system.</div>";
		JFactory::getApplication()->enqueueMessage(JText::_('COM_BWPOSTMAN_UNINSTALL_THANKYOU'), 'message');
	}

	/*
	 * get a variable from the manifest file (actually, from the manifest cache).
	 */
	private function getManifestVar($name) {
		$db		= JFactory::getDbo();
		$query	= $db->getQuery(true);
		
		$query->select($db->quoteName('manifest_cache'));
		$query->from($db->quoteName('#__extensions'));
		$query->where($db->quoteName('element') . " = " . $db->quote('com_bwpostman'));
		$db->SetQuery($query);
		
		$manifest = json_decode($db->loadResult(), true);
		return $manifest[$name];
	}
 
	/*
	 * sets parameter values in the component's row of the extension table
	 */
	private function setParams($param_array) {
		if ( count($param_array) > 0 ) {
			// read the existing component value(s)
			$db		= JFactory::getDbo();
			$query	= $db->getQuery(true);
			
			$query->select($db->quoteName('params'));
			$query->from($db->quoteName('#__extensions'));
			$query->where($db->quoteName('element') . " = " . $db->quote('com_bwpostman'));
			$db->SetQuery($query);
			$params = json_decode($db->loadResult(), true);
			// add the new variable(s) to the existing one(s)
			foreach ( $param_array as $name => $value ) {
				$params[(string) $name] = (string) $value;
			}
			// store the combined new and existing values back as a JSON string
			$paramsString = json_encode($params);
			$query	= $db->getQuery(true);
				
			$query->update($db->quoteName('#__extensions'));
			$query->set($db->quoteName('params') . " = " . $db->quote($paramsString));
			$query->where($db->quoteName('element') . " = " . $db->quote('com_bwpostman'));
			$db->SetQuery($query);
			
			$result = $db->execute();
		}
	}
	
	/*
	 * shows the HTML after installation/update
	 */
	public function showFinished($update){

		$lang = JFactory::getLanguage();
		//Load first english files
		$lang->load('com_bwpostman.sys',JPATH_ADMINISTRATOR,'en_GB',true);
		$lang->load('com_bwpostman',JPATH_ADMINISTRATOR,'en_GB',true);

		//load specific language
		$lang->load('com_bwpostman.sys',JPATH_ADMINISTRATOR,null,true);
		$lang->load('com_bwpostman',JPATH_ADMINISTRATOR,null,true);
		
		$show_update	= false;
		$show_right		= false;
		$release		= str_replace('.', '-', $this->release);
		$lang_ver		= substr($lang->getTag(), 0, 2);
		if ($lang_ver != 'de') {
			$lang_ver = 'en';
			$forum	= "http://www.boldt-webservice.de/en/forum-en/bwpostman.html";
		}
		else {
			$forum	= "http://www.boldt-webservice.de/de/forum/bwpostman.html";
		}
		$manual	= "http://www.boldt-webservice.de/$lang_ver/downloads/bwpostman/bwpostman-$lang_ver-$release.html";

		if ($update) {
			$string_special		= JText::_('COM_BWPOSTMAN_INSTALLATION_UPDATE_SPECIAL_NOTE_DESC');
		}
		else {
			$string_special		= JText::_('COM_BWPOSTMAN_INSTALLATION_INSTALL_SPECIAL_NOTE_DESC');
		}
		$string_new			= JText::_('COM_BWPOSTMAN_INSTALLATION_UPDATE_NEW_DESC');
		$string_improvement	= JText::_('COM_BWPOSTMAN_INSTALLATION_UPDATE_IMPROVEMENT_DESC');
		$string_bugfix		= JText::_('COM_BWPOSTMAN_INSTALLATION_UPDATE_BUGFIX_DESC');
		
		if (($string_bugfix != '' || $string_improvement != '' || $string_new != '') && $update) {
			$show_update	= true;
		}
		if ($show_update || $string_special != '') {
			$show_right	= true;
		}
		?>
		
<link rel="stylesheet" href="components/com_bwpostman/assets/css/install.css" type="text/css" />

<div id="com_bwp_install_header">
	<a href="http://www.boldt-webservice.de" target="_blank">
		<img border="0" align="center" src="components/com_bwpostman/assets/images/bw_header.png" alt="Boldt Webservice" />
	</a>
</div>
<div class="top_line"></div>

<div id="com_bwp_install_outer">
	<h1><?php echo JText::_('COM_BWPOSTMAN_INSTALLATION_WELCOME') ?></h1>
	<div id="com_bwp_install_left">
		<div class="com_bwp_install_welcome">
			<p><?php echo JText::_('COM_BWPOSTMAN_DESCRIPTION') ?></p>
		</div>
		<div class="com_bwp_install_finished">
			<h2>
			<?php
			if($update){
				echo JText::sprintf('COM_BWPOSTMAN_UPGRADE_SUCCESSFUL', $this->release);
				echo '<br />'.JText::_('COM_BWPOSTMAN_EXTENSION_UPGRADE_REMIND');
			} else {
				echo JText::sprintf('COM_BWPOSTMAN_INSTALLATION_SUCCESSFUL', $this->release);
			}
			?>
			</h2>
		</div>
		<?php if ($show_right) { ?>
			<div class="cpanel">
				<div class="icon" >
					<a href="<?php echo JROUTE::_('index.php?option=com_bwpostman'); ?>"> <?php echo JHTML::_('image', 'administrator/components/com_bwpostman/assets/images/icon-48-bwpostman.png', JText::_('COM_BWPOSTMAN_INSTALL_GO_BWPOSTMAN')); ?>
						<span><?php echo JText::_('COM_BWPOSTMAN_INSTALL_GO_BWPOSTMAN'); ?></span>
					</a>
				</div>
				<div class="icon">
					<a href="<?php echo $manual; ?>" target="_blank">
						<?php echo JHTML::_('image', 'administrator/components/com_bwpostman/assets/images/icon-48-manual.png', JText::_('COM_BWPOSTMAN_INSTALL_MANUAL')); ?>
						<span><?php echo JText::_('COM_BWPOSTMAN_INSTALL_MANUAL'); ?></span>
					</a>
				</div>
				<div class="icon">
					<a href="<?php echo $forum; ?>" target="_blank">
						<?php echo JHTML::_('image', 'administrator/components/com_bwpostman/assets/images/icon-48-forum.png', JText::_('COM_BWPOSTMAN_INSTALL_FORUM')); ?>
						<span><?php echo JText::_('COM_BWPOSTMAN_INSTALL_FORUM'); ?></span>
					</a>
				</div>
			</div>
		<?php }?>
	</div>

	<div id="com_bwp_install_right">
		<?php if ($show_right) { ?>
			<?php if ($string_special != '') { ?>
				<div class="com_bwp_install_specialnote">
					<h2><?php echo JText::_('COM_BWPOSTMAN_INSTALLATION_SPECIAL_NOTE_LBL') ?></h2>
					<p class="urgent"><?php echo $string_special; ?></p>
				</div>
			<?php }?>
			
			<?php if ($show_update) { ?>
				<div class="com_bwp_install_updateinfo">
					<h2><?php echo JText::_('COM_BWPOSTMAN_INSTALLATION_UPDATEINFO') ?></h2>
					<?php if ($string_new != '') { ?>
						<h3><?php echo JText::_('COM_BWPOSTMAN_INSTALLATION_UPDATE_NEW_LBL') ?></h3>
						<p><?php echo $string_new; ?></p>
					<?php }?>
					<?php if ($string_improvement != '') { ?>
					<h3><?php echo JText::_('COM_BWPOSTMAN_INSTALLATION_UPDATE_IMPROVEMENT_LBL') ?></h3>
						<p><?php echo $string_improvement; ?></p>
					<?php }?>
					<?php if ($string_bugfix != '') { ?>
						<h3><?php echo JText::_('COM_BWPOSTMAN_INSTALLATION_UPDATE_BUGFIX_LBL') ?></h3>
						<p><?php echo $string_bugfix; ?></p>
					<?php }?>
				</div>
			<?php }?>
		<?php }
		else { ?>
			<div class="cpanel">
				<div class="icon" >
					<a href="<?php echo JROUTE::_('index.php?option=com_bwpostman&token='.JSession::getFormToken()); ?>"> <?php echo JHTML::_('image', 'administrator/components/com_bwpostman/assets/images/icon-48-bwpostman.png', JText::_('COM_BWPOSTMAN_INSTALL_GO_BWPOSTMAN')); ?>
						<span><?php echo JText::_('COM_BWPOSTMAN_INSTALL_GO_BWPOSTMAN'); ?></span>
					</a>
				</div>
				<div class="icon">
					<a href="<?php echo $manual; ?>" target="_blank">
						<?php echo JHTML::_('image', 'administrator/components/com_bwpostman/assets/images/icon-48-bwpostman.png', JText::_('COM_BWPOSTMAN_INSTALL_MANUAL')); ?>
						<span><?php echo JText::_('COM_BWPOSTMAN_INSTALL_MANUAL'); ?></span>
					</a>
				</div>
				<div class="icon">
					<a href="<?php echo $forum; ?>" target="_blank">
						<?php echo JHTML::_('image', 'administrator/components/com_bwpostman/assets/images/icon-48-bwpostman.png', JText::_('COM_BWPOSTMAN_INSTALL_FORUM')); ?>
						<span><?php echo JText::_('COM_BWPOSTMAN_INSTALL_FORUM'); ?></span>
					</a>
				</div>
			</div>
		<?php } ?>
	</div>
	<div class="clr"></div>
	
	<div class="com_bwp_install_footer">
		<p class="small"><?php echo JText::_('&copy; 2012-'); echo date (" Y")?> by <a href="http://www.boldt-webservice.de" target="_blank">Boldt Webservice</a></p>
	</div>
</div>

	<?php
	}

	/**
	 * returns default values for params
	 *
	 * @return  string	Json-encoded default values for params
	 */
	
	private function _setDefaultParams()
	{
		$css_styles = 
"
 body	{
	font-family: Tahoma, Arial, Helvetica, Univers, sans-serif;
	font-size: 15px;
	background:#E9EDF0;
	padding:0px;
	margin:0px;
	padding-bottom:40px;
	color: #3F3F3F;
}
			
.outer	{
	margin: 0 auto;
}
			
.header	{
	padding: 10px auto;
	border-bottom: 5px solid #599DCA;
	text-align: center;
	width: 100%;
}
			
.logo	{
	max-width: 100%;
}
			
.content-outer	{
	max-width: 1000px;
	margin: 10px auto;
}
			
.content	{
	text-align: left;
	background: #E9EDF0;
	border-radius: 8px 8px 8px 8px;
	box-shadow: 1px 1px 3px 2px #599DCA;
	margin: 0 5px;
	padding: 0;
}
			
.content-inner	{
	padding: 20px 15px;
}
			
H1	{
	color: #fff;
	background: #599DCA;
	border-radius: 8px 8px 0 0;
	font-size: 16px;
	font-weight: bold;
	text-align: center;
	padding: 10px 0;
}
			
H2	{
	border-radius: 8px 8px 8px 8px;
	box-shadow: 1px 1px 3px 2px #599DCA;
	color: #3061AF;
	padding: 5px;
}
			
.footer-outer	{
	max-width: 1000px;
	margin: 10px auto;
}
			
.footer-inner	{
	margin: 0 5px;
}
";
				
		$params_default =  array();
		$config	= Jfactory::getConfig();
	
		$params_default['default_from_name']			=  $config->get('fromname');
		$params_default['default_from_email']			=  $config->get('mailfrom');
		$params_default['default_reply_email']			=  $config->get('mailfrom');
		$params_default['default_mails_per_pageload']	=  "100";
		$params_default['use_css_for_html_newsletter'] 	=  "1";
		$params_default['css_for_html_newsletter']		=  $css_styles;
		$params_default['newsletter_show_author']	 	=  "1";
		$params_default['newsletter_show_createdate'] 	=  "1";
		$params_default['show_name_field'] 				=  "1";
		$params_default['show_firstname_field']			=  "1";
		$params_default['name_field_obligation']		=  "1";
		$params_default['firstname_field_obligation']	=  "1";
		$params_default['show_emailformat']				=  "1";
		$params_default['default_emailformat']			=  "1";
		$params_default['disclaimer']					=  "0";
		$params_default['disclaimer_link']				=  "http://www.disclaimer.de/disclaimer.htm";
		$params_default['disclaimer_target']			=  "0";
		$params_default['use_captcha']					=  "0";
		$params_default['pretext']						=  "";
		
		$params	= json_encode($params_default);
			
		$db		= JFactory::getDBO();
		$query	= $db->getQuery(true);
		
		$query	= $db->getQuery(true);
		$query->update($db->quoteName('#__extensions'));
		$query->set($db->quoteName('params') . " = " . $db->quote($params));
		$query->where($db->quoteName('element') . " = " . $db->quote('com_bwpostman'));
			
		$db->SetQuery($query);
		$result = $db->execute();
	}
}
