<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman backend element to select a singlenewsletter for a view in frontend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

/**
 * Renders a newsletter element
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 */

class JFormFieldsinglenews extends JFormField
{
   /**
	* Element name
	*
	* @access	protected
	* @var		string
	*/
	var	$_name = 'Subject';

	protected function getinput()
	{
		$doc 		= JFactory::getDocument();
		$fieldName	= $this->name;

		JTable::addIncludePath(JPATH_ADMINISTRATOR.'/components/com_bwpostman/tables');

		$newsletter = JTable::getInstance('newsletters', 'BwPostmanTable');
		if ($this->value) {
			$newsletter->load($this->value);
		}
		else {
			$newsletter->subject = JText::_('COM_BWPOSTMAN_SELECT_NEWSLETTER');
		}

		$js = "
		function SelectNewsletter(id, subject) {
			document.getElementById('a_id').value = id;
			document.getElementById('a_name').value = subject;
			var btn = window.parent.document.getElementById('sbox-btn-close');
            btn.fireEvent('click');
		}";

		$link = 'index.php?option=com_bwpostman&amp;view=newsletterelement&amp;tmpl=component';
		$doc->addScriptDeclaration($js);

		JHTML::_('behavior.modal', 'a.modal');

		// The active newsletter id field.
		if (0 == (int)$this->value) {
			$value = '';
		}
		else {
			$value = (int)$this->value;
		}

		// class='required' for client side validation
		$class = '';
		if ($this->required) {
			$class = ' class="required modal-value"';
		}


		if (version_compare(JVERSION,'3.0.0','>=')) {
			$html  = '<span class="input-append">';
			$html .= '<input type="text" class="input-medium" id="a_name" value="' . $newsletter->subject . '" disabled="disabled" size="35" />';
			$html .= '<a class="modal btn hasTooltip" title="' . JHtml::tooltipText('COM_BWPOSTMAN_SELECT_NEWSLETTER') . '"  href="' . $link . '" rel="{handler: \'iframe\', size: {x: 800, y: 450}}"><i class="icon-file"></i> ' . JText::_('JSELECT') . '</a>';
			$html .= "\n<input type=\"hidden\" id=\"a_id\" $class name=\"$fieldName\" value=\"$value\" />";
		}
		else {
			$html = "\n<div style=\"float: left;\"><input style=\"background: #ffffff;\" type=\"text\" id=\"a_name\" value=\"$newsletter->subject\" disabled=\"disabled\" /></div>";
			$html .= "<div class=\"button2-left\"><div class=\"blank\"><a class=\"modal\" title=\"".JText::_('COM_BWPOSTMAN_SELECT_NEWSLETTER')."\"  href=\"$link\" rel=\"{handler: 'iframe', size: {x: 650, y: 375}}\">".JText::_('COM_BWPOSTMAN_CHANGE_NEWSLETTER_BUTTON')."</a></div></div>\n";
			$html .= "\n<input type=\"hidden\" id=\"a_id\" $class name=\"$fieldName\" value=\"$value\" />";
		}
		return $html;
	}
}
?>