<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman model for a backend element to select a singlenewsletter for a view in frontend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import MODEL object class
jimport('joomla.application.component.model');

/**
 * BwPostman newsletterelement model
 * Provides a view of single newsletters
 *
 * @package		BwPostman-Admin
 * @subpackage	Newsletterelement
 */
class BwPostmanModelNewsletterelement extends JModelLegacy
{

	/**
	 * Newsletters data
	 *
	 * @var array
	 */
	var $_data = null;

	/**
	 * Number of all newsletters
	 *
	 * @var integer
	 */
	var $_total = null;

	/**
	 * Pagination object
	 *
	 * @var object
	 */
	var $_pagination = null;

	/**
	 * Newsletters search
	 *
	 * @var string
	 */
	var $_search = null;

	/**
	 * Mailinglists key
	 * --> we need this as identifier for the different mailinglists filters (e.g. filter_order, state, search ...)
	 * --> value will be "mailinglists"
	 *
	 * @var	string
	 */
	var $_key = null;

	/**
	 * Constructor
	 * --> handles the pagination and set the mailinglists key
	 */
	public function __construct()
	{
		parent::__construct();

		$app = JFactory::getApplication();

		$this->_key = $this->getName();

		// Get the pagination request variables
		$limit		= $app->getUserStateFromRequest($this->_key.'_limit', 'limit', $app->getCfg('list_limit'), 0);
		$limitstart	= $app->getUserStateFromRequest($this->_key.'_limitstart', 'limitstart', 0);

		$this->setState('limit', $limit);
		$this->setState('limitstart', $limitstart);
	}

	/**
	 * Methode to get the mailinglists data
	 *
	 * @access	public
	 * @return 	object Mailinglists-data
	 */
	public function getData()
	{
		$pagination = $this->getPagination();
		if (empty($this->_data))
		{
			$query = $this->_buildQuery();
			$this->_data = $this->_getList($query, $this->getState('limitstart'), $this->getState('limit'));
		}
		return $this->_data;
	}

	/**
	 * Method to get the total number of mailinglists that shall be displayed
	 *
	 * @access 	public
	 * @return 	int Total number
	 */
	public function getTotal()
	{
		// Load the content if it doesn't already exist
		if (!$this->_total) {
			$query = $this->_buildQuery();
			$this->_total = $this->_getListCount($query);
		}
		return $this->_total;
	}

	/**
	 * Method to get a pagination object for the mailinglists view
	 *
	 * @access 	public
	 * @return 	object Pagination
	 */
	public function getPagination()
	{
		// Load the content if it doesn't already exist
		if (empty($this->_pagination))
		{
			jimport('joomla.html.pagination');
			$this->_pagination = new JPagination($this->getTotal(), $this->getState('limitstart'), $this->getState('limit'));
		}
		return $this->_pagination;
	}

	/**
	 * Method to build the MySQL query
	 *
	 * @access 	private
	 * @return 	string Query
	 */
	private function _buildQuery()
	{
		$_db	= $this->_db;
//		$query	= $_db->getQuery(true);
		
		// Get the WHERE clause and ORDER-BY clause for the query
		$where		= $this->_buildContentWhere();
		$orderby	= $this->_buildContentOrderBy();

		// Build the query
		$query = "SELECT a.id, a.subject, a.mailing_date, a.published 
			FROM {$_db->quoteName('#__bwpostman_newsletters')} AS a
			WHERE a.archive_flag = {$this->_db->Quote('0')}
			{$where}
			{$orderby}"
			;
			return $query;
	}

	/**
	 * Method to build ORDER-BY clause
	 *
	 * @access 	private
	 * @return 	string Query
	 */
	private function _buildContentOrderBy()
	{
		$app = JFactory::getApplication();

		// Get the filter order
		$filter_order = 'a.subject';
		$filter_order_Dir = $app->getUserStateFromRequest($this->_key.'_filter_order_Dir', 'filter_order_Dir', '', 'word');

		if ($filter_order == 'a.subject'){
			$orderby 	= ' ORDER BY a.subject '.$filter_order_Dir;
		}
		else {
			$orderby 	= ' ORDER BY '.$filter_order.' '.$filter_order_Dir.' , a.subject ';
		}
		return $orderby;
	}

	/**
	 * Method to get the search term
	 *
	 * @access 	public
	 * @return 	string
	 */
	private function getSearch()
	{
		if (!$this->_search) {
			$app = JFactory::getApplication();

			$search = $app->getUserStateFromRequest($this->_key.'_search', 'search', '', 'string');
			$this->_search = JString::strtolower($search);
		}
		return $this->_search;
	}

	/**
	 * Method to build the WHERE clause
	 *
	 * @access 	private
	 * @return 	string Query
	 */
	private function _buildContentWhere()
	{
		$app	= JFactory::getApplication();
		$_db	= $this->_db;
		
		// Get the search string
		$search = $this->getSearch();
		$where = '';

		// Get the search filter
		$filter_search = $app->getUserStateFromRequest($this->_key.'_filter_search', 'filter_search', 'subject', 'string');

		if ($search != '') {
			$fields = explode(',', $filter_search);

			$where_array = array();

			$search = '%' . $_db->escape($search, true) . '%';

			foreach ($fields as $field) {
				$where_array[] = 'a.'.$field . " LIKE " . $_db->Quote($search, false);
			}

			$where= ' AND ('
			. implode(' OR ', $where_array)
			.')';
		}

		// Get the state filter
		$filter_state = $app->getUserStateFromRequest($this->_key.'_filter_state', 'filter_state', '', 'word');
		if ($filter_state == 'U') {
			$where = $where
			.' AND a.published ='. (int)'0';
		}
		elseif ($filter_state == 'P') {
			$where = $where
			.' AND a.published ='. (int)'1';
		}
		return $where;
	}
}