-- 
-- Table structure for table `#__bwpostman_campaigns`
-- 

DROP TABLE IF EXISTS `#__bwpostman_campaigns`;
CREATE TABLE IF NOT EXISTS `#__bwpostman_campaigns` (
 `id` int(11) NOT NULL auto_increment,
 `asset_id` int(10) NOT NULL,
 `title` varchar(255) NOT NULL,
 `description` text NOT NULL,
 `access` int(11) NOT NULL,
 `published` tinyint(1) NOT NULL default '0',
 `created_date` datetime NOT NULL default '0000-00-00 00:00:00',
 `created_by` int(10) unsigned NOT NULL default '0',
 `modified_time` datetime NOT NULL default '0000-00-00 00:00:00',
 `modified_by` int(10) unsigned NOT NULL default '0',
 `checked_out` int(11) NOT NULL default '0',
 `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
 `archive_flag` tinyint(1) unsigned NOT NULL default '0',
 `archive_date` datetime NOT NULL default '0000-00-00 00:00:00',
 `archived_by` varchar(11) NOT NULL default '0',
 PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `#__bwpostman_mailinglists`
-- 

DROP TABLE IF EXISTS `#__bwpostman_mailinglists`;
CREATE TABLE IF NOT EXISTS `#__bwpostman_mailinglists` (
 `id` int(11) NOT NULL auto_increment,
 `asset_id` int(10) NOT NULL,
 `title` varchar(255) NOT NULL,
 `description` text NOT NULL,
 `campaign_id` int(11) NOT NULL,
 `access` int(11) NOT NULL,
 `published` tinyint(1) NOT NULL default '0',
 `created_date` datetime NOT NULL default '0000-00-00 00:00:00',
 `created_by` int(10) unsigned NOT NULL default '0',
 `modified_time` datetime NOT NULL default '0000-00-00 00:00:00',
 `modified_by` int(10) unsigned NOT NULL default '0',
 `checked_out` int(11) NOT NULL default '0',
 `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
 `archive_flag` tinyint(1) unsigned NOT NULL default '0',
 `archive_date` datetime NOT NULL,
 `archived_by` varchar(11) NOT NULL default '0',
 PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `#__bwpostman_newsletters`
-- 

DROP TABLE IF EXISTS `#__bwpostman_newsletters`;
CREATE TABLE IF NOT EXISTS `#__bwpostman_newsletters` (
 `id` int(11) NOT NULL auto_increment,
 `asset_id` int(10) NOT NULL,
 `from_name` varchar(255) NOT NULL,
 `from_email` varchar(100) NOT NULL,
 `reply_email` varchar(100) NOT NULL,
 `campaign_id` int(11) NOT NULL,
 `usergroups` varchar(255) NOT NULL,
 `selected_content` varchar(255) NOT NULL,
 `subject` varchar(255) NOT NULL,
  `description` text NOT NULL,
 `attachment` varchar(1000) NOT NULL,
 `html_version` longtext NOT NULL,
 `text_version` longtext NOT NULL,
 `created_date` datetime NOT NULL default '0000-00-00 00:00:00',
 `created_by` int(10) unsigned NOT NULL default '0',
 `modified_time` datetime NOT NULL default '0000-00-00 00:00:00',
 `modified_by` int(10) unsigned NOT NULL default '0',
 `mailing_date` datetime NOT NULL default '0000-00-00 00:00:00',
 `published` tinyint(1) unsigned NOT NULL default '0',
 `checked_out` int(11) NOT NULL default '0',
 `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
 `archive_flag` tinyint(1) unsigned NOT NULL default '0',
 `archive_date` datetime NOT NULL default '0000-00-00 00:00:00',
 `archived_by` varchar(11) NOT NULL default '0',
 `hits` int(11) NOT NULL,
 PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `#__bwpostman_newsletters_mailinglists`
-- 

DROP TABLE IF EXISTS `#__bwpostman_newsletters_mailinglists`;
CREATE TABLE IF NOT EXISTS `#__bwpostman_newsletters_mailinglists` (
 `newsletter_id` int(11) NOT NULL,
 `mailinglist_id` int(11) NOT NULL,
 PRIMARY KEY (`newsletter_id`,`mailinglist_id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `#__bwpostman_sendmailcontent`
-- 

DROP TABLE IF EXISTS `#__bwpostman_sendmailcontent`;
CREATE TABLE IF NOT EXISTS `#__bwpostman_sendmailcontent` (
 `id` int(11) NOT NULL,
 `mode` int(1) NOT NULL,
 `nl_id` int(11) NOT NULL,
 `from_name` varchar(255) NOT NULL,
 `from_email` varchar(100) NOT NULL,
 `subject` varchar(255) NOT NULL,
 `body` longtext NOT NULL,
 `cc_email` varchar(100) NOT NULL,
 `bcc_email` varchar(100) NOT NULL,
 `attachment` text NOT NULL,
 `reply_email` varchar(100) NOT NULL,
 `reply_name` varchar(255) NOT NULL,
 PRIMARY KEY (`id`,`mode`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `#__bwpostman_sendmailqueue`
-- 

DROP TABLE IF EXISTS `#__bwpostman_sendmailqueue`;
CREATE TABLE IF NOT EXISTS `#__bwpostman_sendmailqueue` (
 `id` int(11) NOT NULL auto_increment,
 `content_id` int(11) NOT NULL,
 `recipient` varchar(100) NOT NULL,
 `mode` int(1) NOT NULL,
 `name` varchar(255) NOT NULL,
 `firstname` varchar(255) NOT NULL,
 `subscriber_id` int(11) NOT NULL default '0',
 `trial` int(5) NOT NULL default '0',
 PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `#__bwpostman_subscribers`
-- 

DROP TABLE IF EXISTS `#__bwpostman_subscribers`;
CREATE TABLE IF NOT EXISTS `#__bwpostman_subscribers` (
 `id` int(11) NOT NULL auto_increment,
 `asset_id` int(10) NOT NULL,
 `user_id` int(11) NOT NULL,
 `name` varchar(255) NOT NULL,
 `firstname` varchar(255) NOT NULL,
 `email` varchar(100) NOT NULL,
 `emailformat` tinyint(1) NOT NULL,
 `status` int(1) NOT NULL,
 `activation` varchar(100) NOT NULL,
 `editlink` varchar(100) NOT NULL,
 `registration_date` datetime NOT NULL default '0000-00-00 00:00:00',
 `registered_by` int(11) NOT NULL default '0',
 `registration_ip` varchar(15) NOT NULL,
 `confirmation_date` datetime NOT NULL default '0000-00-00 00:00:00',
 `confirmed_by` int(11) NOT NULL default '0',
 `confirmation_ip` varchar(15) NOT NULL,
 `modified_time` datetime NOT NULL default '0000-00-00 00:00:00',
 `modified_by` int(10) unsigned NOT NULL default '0',
 `checked_out` int(11) NOT NULL default '0',
 `checked_out_time` datetime NOT NULL default '0000-00-00 00:00:00',
 `archive_flag` tinyint(1) NOT NULL default '0',
 `archive_date` datetime NOT NULL default '0000-00-00 00:00:00',
 `archived_by` varchar(11) NOT NULL default '-1',
 PRIMARY KEY (`id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

-- --------------------------------------------------------

-- 
-- Table structure for table `#__bwpostman_subscribers_mailinglists`
-- 

DROP TABLE IF EXISTS `#__bwpostman_subscribers_mailinglists`;
CREATE TABLE IF NOT EXISTS `#__bwpostman_subscribers_mailinglists` (
 `subscriber_id` int(11) NOT NULL,
 `mailinglist_id` int(11) NOT NULL,
 PRIMARY KEY (`subscriber_id`,`mailinglist_id`)
) ENGINE=INNODB DEFAULT CHARSET=utf8 COLLATE utf8_general_ci;

