<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman single newsletter default 4 template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

if (version_compare(JVERSION,'3.0.0','>=')) {
	JHtml::_('bootstrap.tooltip');
	$image = '<i class="icon-info"></i>';
}
else {
	JHTML::_('behavior.tooltip');
	$image = JHTML::_('image', 'administrator/templates/'. $this->template .'/images/menu/icon-16-info.png', JText::_('COM_BWPOSTMAN_NOTES'));
}
$image_testrecipients	= JHTML::_('image', 'administrator/components/com_bwpostman/assets/images/send.png', JText::_('COM_BWPOSTMAN_NL_SEND_TO_TESTRECIPIENTS'));
$image_newsletter		= JHTML::_('image', 'administrator/components/com_bwpostman/assets/images/send_f2.png', JText::_('COM_BWPOSTMAN_NL_SENDMAIL'));

?>

<fieldset class="adminform"><legend><?php echo JTEXT::_('COM_BWPOSTMAN_NL_SENDMAIL'); ?></legend>
	<table class="admintable">
		<tr valign="top">
			<td width="40"><?php echo $image_newsletter; ?></td>
			<td>
				<?php echo JText::_('COM_BWPOSTMAN_NL_SEND_TO_RECIPIENTS'); ?>
				<br /><br />
				<?php echo JText::_('COM_BWPOSTMAN_NL_SEND_TO_RECIPIENTS_NOTE'); ?>
			</td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td><?php echo JText::_('COM_BWPOSTMAN_NL_SEND_OPTIONS');?></td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td><label class="checkbox"><input type="checkbox" id="send_to_unconfirmed" name="send_to_unconfirmed" />&nbsp;<?php echo JText::_('COM_BWPOSTMAN_NL_SEND_TO_UNCONFIRMED');?></label></td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td>
				<input class="input-mini" name="mails_per_pageload" id="mails_per_pageload" size="4" maxlength="10"
					value="<?php echo $this->params->get('default_mails_per_pageload');?>" class="inputbox" />
				<?php echo JText::_('COM_BWPOSTMAN_NL_SEND_MAILS_PER_PAGELOAD'); ?>&nbsp;
				<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_NL_SEND_MAILS_PER_PAGELOAD_NOTE'); ?>"><?php echo $image; ?></span>
				<br /><br />
			</td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td>
				<?php if ($this->canDo->get('core.send')) : ?>
					<input class="btn" type="button" onclick="checkSelectedContent(document.adminForm['jform_selected_content'],document.adminForm['selected_content_old'], document.adminForm['content_exists']);Joomla.submitbutton('newsletter.sendmail');"
						value="<?php echo JText::_('COM_BWPOSTMAN_NL_SENDMAIL_BUTTON'); ?>" />
				<?php endif; ?>
			</td>
		</tr>
	</table>
</fieldset>

<fieldset class="adminform"><legend><?php echo JTEXT::_('COM_BWPOSTMAN_NL_SENDTESTMAIL'); ?></legend>
	<table class="admintable">
		<tr valign="top">
			<td width="40"><?php echo $image_testrecipients; ?></td>
			<td><?php echo JText::_('COM_BWPOSTMAN_NL_SEND_TO_TESTRECIPIENTS'); ?>
				<br /><br />
				<?php echo JText::_('COM_BWPOSTMAN_NL_SEND_TO_TESTRECIPIENTS_NOTE'); ?>
				<br /><br />
				<input type="hidden" id="send_to_unconfirmed" name="send_to_unconfirmed" value="0" />
			</td>
		</tr>
		<tr>
			<td>&nbsp;</td>
			<td>
				<?php if ($this->canDo->get('core.send')) : ?>
					<input class="btn" type="button" onclick="checkSelectedContent(document.adminForm['jform_selected_content'],document.adminForm['selected_content_old'], document.adminForm['content_exists']);Joomla.submitbutton('newsletter.sendtestmail');"
						value="<?php echo JText::_('COM_BWPOSTMAN_NL_SENDTESTMAIL_BUTTON'); ?>" />
				<?php endif; ?>
			</td>
		</tr>
	</table>
</fieldset>
