<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman all newsletters main template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

if (version_compare(JVERSION,'3.0.0','>=')) {
	JHtml::_('bootstrap.tooltip');
	JHtml::_('formbehavior.chosen', 'select');
}
else {
	JHTML::_('behavior.tooltip');
}

JHtml::_('behavior.multiselect');

// Load the modal behavior for the newsletter preview
JHTML::_('behavior.modal', 'a.popup');

//Load tabs behavior for the Tabs
jimport('joomla.html.html.tabs');

//Load tabs behavior for the Tabs
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/bwtabs.php');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

$tab_options = array(
    'onActive' => 'function(title, description){
        description.setStyle("display", "block");
        title.addClass("open").removeClass("closed");
    }',
    'onBackground' => 'function(title, description){
        description.setStyle("display", "none");
        title.addClass("closed").removeClass("open");
    }',
    'useCookie' => 'true', // note the quotes around true, since it must be a string. But if you put false there, you must not use qoutes otherwise JHtmlTabs will handle it as true
);

$app	= JFactory::getApplication();
$tab	= $app->getUserState('com_bwpostman.newsletters.tab', 'unsent');

switch ($tab) {
	default:
	case 'unsent'	: $tab_offset	= 0;
		break;
	case 'sent'		: $tab_offset	= 1;
		break;
	case 'queue'	: $tab_offset	= 2;
		break;
}
$tab_cookie	= false;

$tab_options = array(
		'onActive' => 'function(title, description){
        description.setStyle("display", "block");
        title.addClass("open").removeClass("closed");
    }',
		'onBackground' => 'function(title, description){
        description.setStyle("display", "none");
        title.addClass("closed").removeClass("open");
    }',
		'startOffset' => $tab_offset,  // 0 starts on the first tab, 1 starts the second, etc...
		'useCookie' => $tab_cookie, // note the quotes around true, since it must be a string. But if you put false there, you must not use qoutes otherwise JHtmlTabs will handle it as true
);
?>

<script type="text/javascript">
/* <![CDATA[ */
	Joomla.submitbutton = function (pressbutton) {
		var form = document.adminForm;
		if (pressbutton == 'newsletters.archive') {
			ConfirmArchive = confirm("<?php echo JText::_('COM_BWPOSTMAN_NL_CONFIRM_ARCHIVE' , true); ?>");
			if (ConfirmArchive == true) {
				submitform(pressbutton);
			}
			else {
				return;
			}
		}
		else {
			submitform(pressbutton);		
		}
	}
/* ]]> */
</script>

<?php
// Open modalbox if task == startsending --> we will show the sending process in the modalbox
	$jinput	= JFactory::getApplication()->input;
	$task	= $jinput->get->get('task');
	
	if ($task == "startsending") {
		echo '<script type="text/javascript">'."\n";
		echo "window.addEvent('load', function() {\n";
		echo "SqueezeBox.initialize({handler: 'iframe', size: {x: 600, y: 600}});\n";
		// We cannot replace the "&" with an "&amp;" because it's JavaScript and not HTML
		echo "SqueezeBox.setContent('iframe', 'index.php?option=com_bwpostman&view=newsletter&layout=queue_modal&format=raw&task=continue_sending'); \n";
		echo "});\n";
		echo "</script>\n";
	}
?>

<div id="bwp_view_lists">
	<?php
	if (($jinput->get('task')) != 'startsending'){
			if ($this->queueEntries) {
				JFactory::getApplication()->enqueueMessage(JText::_('COM_BWPOSTMAN_ENTRIES_IN_QUEUE'), 'warning');
			}
 		}
	?>
	<form action="<?php echo JRoute::_('index.php?option=com_bwpostman&view=newsletters'); ?>" method="post" name="adminForm" id="adminForm" class="form-inline">
		<fieldset id="filter-bar" class="well well-small">
			<div class="filter-search fltlft pull-left">
				<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('SEARCH'); ?></label>
				<select name="filter_search_filter" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->filtersearch, 'value', 'text', $this->state->get('filter.search_filter')) ; ?>
				</select>
				<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('COM_BWPOSTMAN_FILTER_SEARCH_DESC'); ?>" />
				
				<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
				<button type="button" class="btn" onclick="document.getElementById('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			</div>

			<div class="filter-select fltrt pull-right">
				<select name="filter_published" class="inputbox" onchange="this.form.submit()">
					<option value=""><?php echo JText::_('JOPTION_SELECT_PUBLISHED');?></option>
					<?php echo JHtml::_('select.options', JHtml::_('jgrid.publishedOptions'), 'value', 'text', $this->state->get('filter.published'), true);?>
				</select>

				<select name="filter_campaign" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->campaigns, 'value', 'text', $this->state->get('filter.campaign')) ; ?>
				</select>

				<select name="filter_author" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->authors, 'value', 'text', $this->state->get('filter.author')) ; ?>
				</select>
		        <?php
		        if (version_compare(JVERSION,'3.0.0','>=')) {
		          echo $this->pagination->getLimitBox();
				}
		        ?>
			</div>
		</fieldset>
		
		<div>
			<?php
				echo JHtmlBwTabs::start('bwpostman_newsletters_tabs-tabs', $tab_options);
				echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_NL_UNSENT'), 'unsent', 
					" 
						document.adminForm.getElementById('tab').setAttribute('value', 'unsent');
						Joomla.submitbutton('newsletters.changeTab');
					");	
		
				echo $this->loadTemplate('unsent');
				
				echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_NL_SENT'), 'sent',
					"
						document.adminForm.getElementById('tab').setAttribute('value', 'sent');
						Joomla.submitbutton('newsletters.changeTab');
					");
				
				echo $this->loadTemplate('sent');

				if (count($this->queue) > 0) {
					echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_NL_QUEUE'), 'queue',
						"
							document.adminForm.getElementById('tab').setAttribute('value', 'queue');
							Joomla.submitbutton('newsletters.changeTab');
						");
				
					echo $this->loadTemplate('queue');

				}
			echo JHtmlBwTabs::end();
			?>
		</div>
		<p class="pagination"><?php echo $this->pagination->getListFooter(); ?></p>
		<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
		
		<input type="hidden" name="task" value="" />
		<input type="hidden" id="tab" name="tab" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo JHTML::_('form.token'); ?>
	</form>
</div>