<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman all newsletters view for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import VIEW object class
jimport('joomla.application.component.view');

// Require helper class
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/helper.php');


/**
 * BwPostman Newsletters View
 *
 * @package 	BwPostman-Admin
 * @subpackage 	Newsletters
 */
class BwPostmanViewNewsletters extends JViewLegacy
{
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display
	 *
	 * @access	public
	 * @param	string Template
	 */
	public function display($tpl = null)
	{
		$app		= JFactory::getApplication();
		$user		= JFactory::getUser();
		$uri		= JFactory::getURI();
		$uri_string	= str_replace('&', '&amp;', $uri->toString());
		$model		= $this->getModel();
		$table		= $model->getTable('newsletters', 'BwPostmanTable');
		
		//check for queue entries
		$this->queueEntries	= BwPostmanHelper::checkQueueEntries();

		// Build the key for the userState
		$key = $this->getName();

		// The query always contains the tab which we are in, but this might be confusing
		// That's why we will set the query only to controller = newsletters
		$uri_query	= 'option=com_bwpostman&view=newsletters';
		$uri->setQuery($uri_query);

		// Get data from the model
		$this->state		= $this->get('State');
		$this->items 		= $this->get('Items');
		$this->queue 		= $this->get('Queue');
		$this->campaigns	= $this->get('CampaignList');
		$this->authors		= $this->get('AuthorList');
		$this->pagination	= $this->get('Pagination');
		$this->total 		= $this->get('total');
		$this->context		= 'com_bwpostman.newsletters';
		
		// Build the filter_search select list
		$filtersearch 	= array ();
		$filtersearch[]	= JHTML::_('select.option', 'subject', JText::_('COM_BWPOSTMAN_NL_FILTER_SEARCH_SUBJECT'));
		$filtersearch[] = JHTML::_('select.option',  'html_version', JText::_('COM_BWPOSTMAN_NL_FILTER_SEARCH_HTML'));
		$filtersearch[] = JHTML::_('select.option',  'text_version', JText::_('COM_BWPOSTMAN_NL_FILTER_SEARCH_TEXT'));
		$filtersearch[] = JHTML::_('select.option',  'html_text_version', JText::_('COM_BWPOSTMAN_NL_FILTER_SEARCH_HTMLTEXT'));
		
		// Save a reference into view
		$this->assignRef('filtersearch', $filtersearch);
		
		$this->addToolbar();

		// Call parent display
		parent::display($tpl);
	}

	/**
	 * Add the page title, submenu and toolbar.
	 *
	 */
	protected function addToolbar()
	{
		$app	= JFactory::getApplication();
		$jinput	= JFactory::getApplication()->input;
		$tab	= $app->getUserState('com_bwpostman.newsletters.tab', 'unsent');
		$canDo	= BwPostmanHelper::getActions(0, 'newsletters');
		
		// Get document object, set document title and add css
		$document = JFactory::getDocument();
		$document->setTitle(JText::_('COM_BWPOSTMAN_NLS'));
		$document->addStyleSheet('components/com_bwpostman/assets/css/bwpostman_backend.css');
		
		// Set toolbar title
		if (version_compare(JVERSION,'3.0.0','>=')) {
			JToolBarHelper::title (JText::_('COM_BWPOSTMAN_NLS'), 'envelope');
		}
		else {
			JToolBarHelper::title (JText::_('COM_BWPOSTMAN_NLS'), 'newsletters');
		}
				
		// Create menu
		JSubMenuHelper::addEntry(JText::_('COM_BWPOSTMAN_MENU_MAIN_ENTRY'), 'index.php?option=com_bwpostman');
		JSubMenuHelper::addEntry(JText::_('COM_BWPOSTMAN_MENU_MAIN_ENTRY_NLS'), 'index.php?option=com_bwpostman&view=newsletters', true);
		JSubMenuHelper::addEntry(JText::_('COM_BWPOSTMAN_MENU_MAIN_ENTRY_SUBS'), 'index.php?option=com_bwpostman&view=subscribers');
		JSubMenuHelper::addEntry(JText::_('COM_BWPOSTMAN_MENU_MAIN_ENTRY_CAMS'), 'index.php?option=com_bwpostman&view=campaigns');
		JSubMenuHelper::addEntry(JText::_('COM_BWPOSTMAN_MENU_MAIN_ENTRY_MLS'), 'index.php?option=com_bwpostman&view=mailinglists');
		if ($canDo->get('core.archive'))	JSubMenuHelper::addEntry(JText::_('COM_BWPOSTMAN_MENU_MAIN_ENTRY_ARC'), 'index.php?option=com_bwpostman&view=archive&layout=newsletters');
		if ($canDo->get('core.admin'))		JSubMenuHelper::addEntry(JText::_('COM_BWPOSTMAN_MENU_MAIN_ENTRY_MAINTENANCE'), 'index.php?option=com_bwpostman&view=maintenance');
		
		// Set toolbar items for the page
		
		switch ($tab) { // The layout-variable tells us which tab we are in
			case "sent":
				if ($canDo->get('core.edit.state'))	{
					JToolBarHelper::publishList('newsletters.publish');
					JToolBarHelper::unpublishList('newsletters.unpublish');
					JToolBarHelper::divider();
					JToolBarHelper::spacer();
				}
				if ($canDo->get('core.create'))	{
					JToolBarHelper::custom('newsletter.copy', 'copy.png', 'copy_f2.png', 'Copy', true);
					JToolBarHelper::divider();
					JToolBarHelper::spacer();
				}
				if ($canDo->get('core.admin')) {
					JToolBarHelper::checkin('newsletter.checkin');
					JToolBarHelper::divider();
					JToolBarHelper::spacer();
				}
				if ($canDo->get('core.archive')) {
					JToolBarHelper::archiveList('newsletter.archive');
					JToolBarHelper::divider();
					JToolBarHelper::spacer();
				}
				break;
			case "queue":
				$bar= JToolBar::getInstance('toolbar');
				$alt = "COM_BWPOSTMAN_NL_CONTINUE_SENDING";
				if ($canDo->get('core.send')) {
					JToolBarHelper::custom('newsletters.resetSendAttempts', 'unpublish.png', 'unpublish_f2.png', 'COM_BWPOSTMAN_NL_RESET_TRIAL', false);
					if (version_compare(JVERSION,'3.0.0','>=')) {
						$bar->appendButton('Popup', 'envelope', $alt, 'index.php?option=com_bwpostman&view=newsletter&layout=queue_modal&format=raw&task=continue_sending', 600, 600);
					}
					else {
						$bar->appendButton('Popup', 'send', $alt, 'index.php?option=com_bwpostman&view=newsletter&layout=queue_modal&format=raw&task=continue_sending', 600, 600);
					}
					JToolBarHelper::custom('newsletters.clear_queue', 'delete.png', 'delete_f2.png', 'COM_BWPOSTMAN_NL_CLEAR_QUEUE', false);
				}
				break;
			case "unsent":
			default:
				if ($canDo->get('core.create'))	JToolBarHelper::addNew('newsletter.add');
				if (($canDo->get('core.edit')) || ($canDo->get('core.edit.own')))	JToolBarHelper::editList('newsletter.edit');
				if ($canDo->get('core.create'))	JToolBarHelper::custom('newsletter.copy', 'copy.png', 'copy_f2.png', 'Copy', true);
				JToolBarHelper::divider();
				JToolBarHelper::spacer();
				
				if (version_compare(JVERSION,'3.0.0','>=')) {
					if ($canDo->get('core.send')) {
						JToolBarHelper::custom('newsletter.sendOut', 'envelope', 'send_f2.png', 'COM_BWPOSTMAN_NL_SEND', true);
						JToolBarHelper::divider();
						JToolBarHelper::spacer();
					}
				}
				else {
					if ($canDo->get('core.send')) {
						JToolBarHelper::custom('newsletter.sendOut', 'send.png', 'send_f2.png', 'COM_BWPOSTMAN_NL_SEND', true);
						JToolBarHelper::divider();
						JToolBarHelper::spacer();
					}
				}
				if ($canDo->get('core.archive')) {
					JToolBarHelper::archiveList('newsletter.archive');
					JToolBarHelper::divider();
					JToolBarHelper::spacer();
				}
				if ($canDo->get('core.manage')) {
					JToolBarHelper::checkin('newsletter.checkin');
					JToolBarHelper::divider();
				}
				break;
		}
		JToolBarHelper::help(JText::_("COM_BWPOSTMAN_FORUM"), false, 'http://www.boldt-webservice.de/forum/bwpostman.html');
		JToolBarHelper::spacer();
	}	
}