<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman newsletter all model for frontend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Site
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import MODEL object class
jimport('joomla.application.component.modellist');

class BwPostmanModelNewsletters extends JModelList
{

	public $_context = 'com_bwpostman.newsletters';

	protected $_extension = 'com_bwpostman';

	private $_items = null;

	protected $_newsletters = null;

	/**
	 * Newsletter data
	 *
	 * @var array
	 */
	var $_data = null;

	/**
	 * Number of all Newsletters which are shown
	 *
	 * @var int
	 */
	var $_total = null;

	/**
	 * Pagination object
	 *
	 * @var object
	 */
	var $_pagination = null;

	/**
	 * Newsletter filter
	 *
	 * @var string
	 */
	var $_filter = null;

	/**
	 * Constructor
	 *
	 */
	public function __construct()
	{
		parent::__construct();

		$app 	= JFactory::getApplication();
		$jinput	= JFactory::getApplication()->input;
		
		$id = $jinput->get('id');
		$this->setId((int)$id);

		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'a.subject', 'subject',
				'a.mailing_date', 'mailing_date',
				'a.id', 'id',
				'access','access_level',
				'language',
				'a.hits', 'hits',
				'ordering'
			);
		}
		parent::__construct($config);
	}

	/**
	 * Returns a Table object, always creating it.
	 *
	 * @param	type	The table type to instantiate
	 * @param	string	A prefix for the table class name. Optional.
	 * @param	array	Configuration array for model. Optional.
	 *
	 * @return	JTable	A database object
	 * 
	 * @since  1.0.1
	*/
	public function getTable($type = 'Newsletters', $prefix = 'BwPostmanTable', $config = array())
	{
		return JTable::getInstance($type, $prefix, $config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @since	1.0.1
	 */
	protected function populateState($ordering = NULL, $direction = NULL)
	{
		// Initiliase variables.
		$app	= JFactory::getApplication('site');
		$jinput	= JFactory::getApplication()->input;
		$pk		= $jinput->getInt('id');
		
		// Load state from the request.
		$this->setState('newsletter.id', $pk);

		// Load the parameters. Merge Global and Menu Item params into new object
		$params = $app->getParams();
		$menuParams = new JRegistry;

		if ($menu = $app->getMenu()->getActive()) {
			$menuParams->loadString($menu->params);
		}

		$mergedParams = clone $menuParams;
		$mergedParams->merge($params);

		$this->setState('params', $mergedParams);
		
		// Optional filter text
		$this->setState('filter.search', $jinput->getString('filter_search'));
		
		// filter.order
		$itemid		= $jinput->getInt('id', 0) . ':' . $jinput->getInt('Itemid', 0);
		$orderCol	= $app->getUserStateFromRequest('com_bwpostman.newsletters.list.' . $itemid . '.filter_order', 'filter_order', 'mailing_date', 'string');
		if (!in_array($orderCol, $this->filter_fields)) {
			$orderCol = 'a.mailing_date';
		}
		$this->setState('list.ordering', $orderCol);
		
		$listOrder = $app->getUserStateFromRequest('com_bwpostman.newsletters.list.' . $itemid . '.filter_order_Dir',
				'filter_order_Dir', 'DESC', 'cmd');
		if (!in_array(strtoupper($listOrder), array('ASC', 'DESC', ''))) {
			$listOrder = 'DESC';
		}
		$this->setState('list.direction', $listOrder);
		
		$this->setState('list.start', $jinput->getUInt('limitstart', 0));
		
		// set limit for query. If list, use parameter. If blog, add blog parameters for limit.
		$limit = $app->getUserStateFromRequest('com_bwpostman.newsletters.list.' . $itemid . '.limit', 'limit', $params->get('display_num'), 'uint');
		
		$this->setState('list.limit', $limit);
		
		$this->setState('layout', JFactory::getApplication()->input->getCmd('layout'));
		
		$offset = $jinput->getUint('start');
		$this->setState('list.offset', $offset);

		// TODO: Tune these values based on other permissions.
		$user		= JFactory::getUser();
		if ((!$user->authorise('core.edit.state', 'com_bwpostman')) &&  (!$user->authorise('core.edit', 'com_bwpostman'))){
			$this->setState('filter.published', 1);
			$this->setState('filter.archived', 2);
		}
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param	string		$id	A prefix for the store id.
	 *
	 * @return	string		A store id.
	 * @since	1.0.1
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id .= ':' . serialize($this->getState('filter.published'));
		$id .= ':' . $this->getState('filter.access');
		$id .= ':' . $this->getState('filter.subject');
		$id .= ':' . $this->getState('filter.mailing_date');
		$id .= ':' . $this->getState('filter.hits');

		return parent::getStoreId($id);
	}

	/**
	 * Method to reset the newsletter ID and newsletter data
	 *
	 * @access	public
	 * @param	int	Newsletter ID
	 */
	public function setId($id = 0)
	{
		// Set new venue ID and wipe data
		$this->_id 		= $id;
		$this->_data 	= null;
	}

	/**
	 * Method to get a list of articles.
	 *
	 * Overriden to inject convert the attribs field into a JParameter object.
	 *
	 * @return	mixed	An array of objects on success, false on failure.
	 * @since	1.0.1
	 */
	public function getItems()
	{
		$items	= parent::getItems();

		$this->_pagination = parent::getPagination();

		return $items;
	}

	/**
	 * Method to build the MySQL query
	 *
	 * @access public?
	 * @return string Query
	 * @since	1.0.1
	 */
	protected function getListQuery()
	{
		$user		= JFactory::getUser();
		$_db		= $this->_db;
		$query		= $_db->getQuery(true);
		$subQuery	= $_db->getQuery(true); 
		
		// get allowed mailinglist IDs
		$accessible	= $this->_getAllowedMailinglists();
		
		//Sub-Query for accessible mailinglists
		$subQuery->select($_db->quoteName('newsletter_id'));
		$subQuery->from($_db->quoteName('#__bwpostman_newsletters_mailinglists')  . ' AS ' . $_db->quoteName('m'));
		$subQuery->where($_db->quoteName('a') . '.' . $_db->quoteName('id') . ' = ' . $_db->quoteName('m') . '.' . $_db->quoteName('newsletter_id'));
		$subQuery->where($_db->quoteName('m') . '.' . $_db->quoteName('mailinglist_id') . ' IN (' . implode(',', $accessible) . ')');
		
		$query->select(
			$this->getState(
				'list.select',
				'a.id, a.subject, a.mailing_date, a.hits'
			)
		);
						
		$query->from($_db->quoteName('#__bwpostman_newsletters') . ' AS ' . $_db->quoteName('a'));
		$query->where($_db->quoteName('a') . '.' . $_db->quoteName('archive_flag') . ' = ' . (int) 0);
		$query->where($_db->quoteName('a') . '.' . $_db->quoteName('published') . ' = ' . (int) 1);
		$query->where($_db->quoteName('a') . '.' . $_db->quoteName('mailing_date') . ' != ' . $_db->Quote('0000-00-00 00:00:00'));
		$query->where($_db->quoteName('a') . '.' . $_db->quoteName('id') . ' IN (' . $subQuery . ')');
		
		// Filter by access level.
		if ($access = $this->getState('filter.access')) {
			$groups	= implode(',', $user->getAuthorisedViewLevels());
			$query->where('access IN ('.$groups.')');
		}

		// Filter by search word.
		$search			= '%' . $_db->escape($this->getState('filter.search'), true) . '%';
		
		if (!empty($search)) $query->where('subject LIKE ' . $_db->Quote($search, false));
		
		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering', 'a.mailing_date');
		$orderDirn	= $this->state->get('list.direction', 'DESC');
		
		// Add the list ordering clause.
		$query->order($_db->escape($orderCol.' '.$orderDirn));
		$_db->setQuery($query);
		return $query;
	}


	/**
	 * Method to get all mailinglists which the user is authorized to see
	 *
	 * @access 	protected
	 * @return 	mailinglists object
	 * @since	1.0.1
	 */
	protected function _getAllowedMailinglists()
	{
		$user 		= JFactory::getUser();
		$_db		= $this->_db;
		$query		= $_db->getQuery(true);

		// get authorized viewlevels
		$accesslevels	= JAccess::getAuthorisedViewLevels($user->id);

		if (!in_array('3', $accesslevels)) {
			// A user shall only see mailinglists which are public or - if registered - accessible for his viewlevel and published
			$query->select('id');
			$query->from($_db->quoteName('#__bwpostman_mailinglists'));
			$query->where($_db->quoteName('access') . ' IN (' . implode(',', $accesslevels) . ')');
			$query->where($_db->quoteName('published') . ' = ' . (int) 1);
			$query->where($_db->quoteName('archive_flag') . ' = ' . (int) 0);
		} 
		else {
			// A user with a super user status shall see all mailinglists
			$query->select('id');
			$query->from($_db->quoteName('#__bwpostman_mailinglists'));
			$query->where($_db->quoteName('published') . ' = ' . (int) 1);
			$query->where($_db->quoteName('archive_flag') . ' = ' . (int) 0);
		}

		$_db->setQuery ($query);

		$mailinglists = $_db->loadColumn();

		return $mailinglists;
	}

}