<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman edit default template for frontend.
 *
 * @version 3.1.9
 * @package BwPostman-Site
 * @author Romana Boldt
 * @copyright (C) 2021 Boldt Webservice <forum@boldt-webservice.de>
 * @support https://www.boldt-webservice.de/en/forum-en/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Router\Route;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Uri\Uri;

JHtml::_('stylesheet', 'com_bwpostman/bwpostman.css', array('version' => 'auto', 'relative' => true));
$templateName	= Factory::getApplication()->getTemplate();
$css_filename	= 'templates/' . $templateName . '/css/com_bwpostman.css';
JHtml::_('stylesheet', $css_filename, array('version' => 'auto'));

HtmlHelper::_('formbehavior.chosen', 'select');
HtmlHelper::_('behavior.formvalidator');

HTMLHelper::_('bootstrap.tooltip');

?>

<script type="text/javascript">
/* <![CDATA[ */
	function submitbutton(pressbutton)
	{
		var form	= document.bwp_com_form;
		var fault	= false;

		form.edit.value = pressbutton;

		// Validate input fields only, if unsubscribe is not selected
		if (form.unsubscribe.checked == false)
		{
			if (document.bwp_com_form.name)
			{
				if (form.name_field_obligation.value == 1)
				{
					if (form.name.value == "")
					{
						alert("<?php echo Text::_('COM_BWPOSTMAN_ERROR_NAME', true); ?>");
						fault = true;
					}
				}
			}

			if (document.bwp_com_form.firstname)
			{
				if (form.firstname_field_obligation.value == 1)
				{
					if (form.firstname.value == "")
					{
						alert("<?php echo Text::_('COM_BWPOSTMAN_ERROR_FIRSTNAME', true); ?>");
						fault = true;
					}
				}
			}
			if (document.bwp_com_form.special)
			{
				if (form.special_field_obligation.value == 1)
				{
					if (form.special.value == "")
					{
						alert('<?php echo Text::sprintf("COM_BWPOSTMAN_SUB_ERROR_SPECIAL", Text::_($this->params->get("special_label"))); ?>');
						fault = true;
					}
				}
			}
			if (form.email.value== "")
			{
				alert("<?php echo Text::_('COM_BWPOSTMAN_ERROR_EMAIL', true); ?>");
				fault	= true;
			}
			if (checkNlBoxes()== false)
			{
				alert ("<?php echo Text::_('COM_BWPOSTMAN_ERROR_NL_CHECK', true); ?>");
				fault	= true;
			}
		}
		if (fault == false)
		{
			form.submit();
		}
		function checkNlBoxes()
		{
			var arrCB = form.elements['mailinglists[]'];
			var n =	arrCB.length;
			var check = 0;
			var i = 0;
			if (n > 1)
			{
				for (i = 0; i < n; i++)
				{
					if (arrCB[i].checked == true)
					{
						check++;
					}
				}
			}
			else
			{
				check++;
			}
			if (check == 0)
			{
				return false;
			}
		}
	}
/* ]]> */
</script>

<noscript>
	<div id="system-message">
		<div class="alert alert-warning">
			<h4 class="alert-heading"><?php echo Text::_('WARNING'); ?></h4>
			<div>
				<p><?php echo Text::_('COM_BWPOSTMAN_JAVASCRIPTWARNING'); ?></p>
			</div>
		</div>
	</div>
</noscript>

<div id="bwpostman">
	<div id="bwp_com_edit_subscription">
		<?php if (($this->params->get('show_page_heading') != 0) && ($this->params->get('page_heading') != '')) : ?>
			<h1 class="componentheading<?php echo $this->params->get('pageclass_sfx'); ?>">
				<?php echo $this->escape($this->params->get('page_heading')); ?>
			</h1>
		<?php endif; ?>

		<div class="content_inner">
			<form action="<?php echo Route::_('index.php?option=com_bwpostman'); ?>" method="post" id="bwp_com_form"
					name="bwp_com_form" class="form-validate form-inline">

				<div class="contentpane<?php echo $this->params->get('pageclass_sfx'); ?>">

					<?php // Show pretext only if set in basic parameters
					if ($this->params->get('pretext'))
					{
						$preText = Text::_($this->params->get('pretext'));
						?>
						<p class="pre_text"><?php echo $preText; ?></p>
						<?php
					} // End: Show pretext only if set in basic parameters ?>

					<?php // Show formfield gender only if enabled in basic parameters
					if ($this->params->get('show_gender') == 1)
					{ ?>
						<p class="edit_gender">
							<label id="gendermsg"> <?php echo Text::_('COM_BWPOSTMAN_GENDER'); ?>:</label>
							<?php echo $this->lists['gender']; ?>
						</p> <?php
					} // End gender ?>

					<?php // Show first name-field only if set in basic parameters
					if ($this->params->get('show_firstname_field') || $this->params->get('firstname_field_obligation'))
					{ ?>
						<p class="user_firstname input<?php echo ($this->params->get('firstname_field_obligation')) ? '-append' : '' ?>">
							<label id="firstnamemsg" for="firstname">
								<?php echo Text::_('COM_BWPOSTMAN_FIRSTNAME'); ?>: </label>
							<?php // Is filling out the firstname field obligating
							if ($this->params->get('firstname_field_obligation'))
							{ ?>
								<input type="text" name="firstname" id="firstname" size="40"
										value="<?php
										if (!empty($this->subscriber->firstname))
										{
											echo $this->subscriber->firstname;
										} ?>"
										class="<?php
										if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code == 1))
										{
											echo "invalid";
										} ?>"
										maxlength="50" /> <span class="append-area"><i class="icon-star"></i></span>
							<?php
							}
							else
							{ ?>
								<input type="text" name="firstname" id="firstname" size="40"
										value="<?php echo $this->subscriber->firstname; ?>"
										class="<?php
										if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code == 1))
										{
											echo "invalid";
										}
										else
										{
											echo "inputbox";
										} ?>"
										maxlength="50" />
							<?php
							}

							// End: Is filling out the firstname field obligating
							?>
						</p> <?php
					}

					// End: Show first name-field only if set in basic parameters ?>

					<?php // Show name-field only if set in basic parameters
					if ($this->params->get('show_name_field') || $this->params->get('name_field_obligation'))
					{ ?>
						<p class="user_name edit_name input<?php echo ($this->params->get('name_field_obligation')) ? '-append' : '' ?>">
							<label id="namemsg" for="name"
								<?php
								if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code == 1))
								{
									echo "class=\"invalid\"";
								} ?>>
								<?php echo Text::_('COM_BWPOSTMAN_NAME'); ?>: </label>
							<?php // Is filling out the name field obligating
							if ($this->params->get('name_field_obligation'))
							{
								?>
								<input type="text" name="name" id="name" size="40" value="<?php echo $this->subscriber->name; ?>"
										class="<?php
										if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code == 1))
										{
											echo "invalid";
										} ?>"
										maxlength="50" />  <span class="append-area"><i class="icon-star"></i></span> <?php
							}
							else
							{ ?>
								<input type="text" name="name" id="name" size="40" value="<?php echo $this->subscriber->name; ?>"
									class="<?php
									if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code == 1)) {
										echo "invalid";
									}
									else
									{
										echo "inputbox";
									} ?>"
									maxlength="50" /> <?php
							}

							// End: Is filling out the name field obligating
							?>
						</p> <?php
					}

					// End: Show name-fields only if set in basic parameters ?>

					<?php // Show special only if set in basic parameters or required
					if ($this->params->get('show_special') || $this->params->get('special_field_obligation'))
					{
						if ($this->params->get('special_desc') != '')
						{
							$tip = Text::_($this->params->get('special_desc'));
						}
						else
						{
							$tip = Text::_('COM_BWPOSTMAN_SPECIAL');
						} ?>

						<p class="edit_special input<?php echo ($this->params->get('special_field_obligation')) ? '-append' : '' ?>">
							<label id="specialmsg" class="hasTooltip" title="<?php echo HtmlHelper::tooltipText($tip); ?>" for="special"
								<?php
								if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code == 1))
								{
									echo " class=\"invalid\"";
								}
								echo ">";
								if ($this->params->get('special_label') != '')
								{
									echo Text::_($this->params->get('special_label'));
								}
								else
								{
									echo Text::_('COM_BWPOSTMAN_SPECIAL');
								}
								?>:
							</label>
							<?php // Is filling out the special field obligating
							if ($this->params->get('special_field_obligation'))
							{ ?>
								<input type="text" name="special" id="special" size="40" value="<?php echo $this->subscriber->special; ?>"
										class="<?php
										if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code == 1))
										{
											echo "invalid";
										}
										else
										{
											echo "inputbox";
										} ?>"
										maxlength="50" /> <span class="append-area"><i class="icon-star"></i></span> <?php
							}
							else
							{ ?>
								<input type="text" name="special" id="special" size="40" value="<?php echo $this->subscriber->special; ?>"
										class="<?php
										if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code == 1))
										{
											echo "invalid";
										}
										else
										{
											echo "inputbox";
										} ?>"
										maxlength="50" /> <?php
							}

							// End: Is filling out the special field obligating
							?>
						</p> <?php
					} // End: Show special field only if set in basic parameters ?>

					<p class="user_email edit_email input-append">
						<label id="emailmsg" for="email"
							<?php
							if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code != 1))
							{
								echo "class=\"invalid\"";
							} ?>>
							<?php echo Text::_('COM_BWPOSTMAN_EMAIL'); ?>:
						</label>
						<input type="text" id="email" name="email" size="40" value="<?php echo $this->subscriber->email; ?>"
							class="<?php
							if ((!empty($this->subscriber->err_code)) && ($this->subscriber->err_code != 1))
							{
								echo "invalid";
							}
							else
							{
								echo "inputbox validate-email";
							} ?>"
							maxlength="100" />  <span class="append-area"><i class="icon-star"></i></span>
					</p>

					<?php
					// Show formfield email format only if enabled in basic parameters
					if ($this->params->get('show_emailformat') == 1)
					{ ?>
						<div class="user_mailformat edit_emailformat">
							<label id="emailformatmsg"><?php echo Text::_('COM_BWPOSTMAN_EMAILFORMAT'); ?>: </label>
							<?php echo $this->lists['emailformat']; ?>
						</div>
					<?php
					}
					else
					{
						// hidden field with the default email format
						?>
						<input type="hidden" name="emailformat" value="<?php echo $this->params->get('default_emailformat'); ?>" />
					<?php
					}

					// End email format
					?>

					<?php
					// Show available mailinglists
					if ($this->lists['available_mailinglists'])
					{ ?>
						<div class="maindivider<?php echo $this->params->get('pageclass_sfx'); ?>"></div>

						<div class="contentpane<?php echo $this->params->get('pageclass_sfx'); ?>">
							<?php
							$n = count($this->lists['available_mailinglists']);

							$descLength = $this->params->get('desc_length');

							if ($this->lists['available_mailinglists'] && ($n > 0))
							{
								if ($n == 1)
								{ ?>
									<input title="mailinglists_array" type="checkbox" style="display: none;" id="<?php echo "mailinglists0"; ?>"
											name="<?php echo "mailinglists[]"; ?>" value="<?php echo $this->lists['available_mailinglists'][0]->id; ?>" checked="checked" />
									<?php
									if ($this->params->get('show_desc') == 1)
									{ ?>
										<p class="mail_available">
											<?php echo Text::_('COM_BWPOSTMAN_MAILINGLIST'); ?>
										</p>
										<p class="mailinglist-description-single">
											<span class="mail_available_list_title">
												<?php echo $this->lists['available_mailinglists'][0]->title . ": "; ?>
											</span>
											<?php
											echo substr(Text::_($this->lists['available_mailinglists'][0]->description), 0, $descLength);

											if (strlen(Text::_($this->lists['available_mailinglists'][0]->description)) > $descLength)
											{
												echo '... ';
												echo HtmlHelper::tooltip(Text::_($this->lists['available_mailinglists'][0]->description),
													$this->lists['available_mailinglists'][0]->title, 'tooltip.png', '', '');
											} ?>
										</p>
										<?php
									}
								}
								else
								{ ?>
									<p class="mail_available">
										<?php echo Text::_('COM_BWPOSTMAN_MAILINGLISTS') . ' <sup><i class="icon-star"></i></sup>'; ?>
									</p>
									<?php
									foreach ($this->lists['available_mailinglists'] as $i => $item)
									{ ?>
										<p class="mail_available_list <?php echo "mailinglists$i"; ?>">
											<input title="mailinglists_array" type="checkbox" id="<?php echo "mailinglists$i"; ?>"
													name="<?php echo "mailinglists[]"; ?>" value="<?php echo $item->id; ?>"
											<?php
											if ((is_array($this->subscriber->mailinglists)) && (in_array((int) $item->id,
													$this->subscriber->mailinglists)))
											{
												echo "checked=\"checked\"";
											} ?> />
											<span class="mail_available_list_title">
												<?php echo $this->params->get('show_desc') == 1 ? $item->title . ": " : $item->title; ?>
											</span>
											<?php
											if ($this->params->get('show_desc') == 1)
											{ ?>
											<span>
												<?php
												echo substr(Text::_($item->description), 0, $descLength);
												if (strlen(Text::_($item->description)) > $descLength)
												{
													echo '... ';
													echo HtmlHelper::tooltip(Text::_($item->description), $item->title, 'tooltip.png', '', '');
												} ?>
											</span>
											<?php
											} ?>
										</p>
										<?php
									} ?>
									<div class="maindivider<?php echo $this->params->get('pageclass_sfx'); ?>"></div>
									<?php
								}
							}?>
						</div>

						<?php
					}

					// End Mailinglists ?>

				</div>

				<div class="contentpane<?php echo $this->escape($this->params->get('pageclass_sfx')); ?>">
					<p class="edit_unsubscribe">
						<input title="unsubscribe" type="checkbox" id="unsubscribe" name="unsubscribe" value="1" />
						<span class="edit_unsubscribe_text"><?php echo Text::_('COM_BWPOSTMAN_UNSUBSCRIBE') ?></span>
					</p>
				</div>

				<div class="maindivider<?php echo $this->escape($this->params->get('pageclass_sfx')); ?>"></div>

				<div class="w-100 contentpane<?php echo $this->escape($this->params->get('pageclass_sfx')); ?>">
					<p class="edit_required">
						<?php echo Text::_('COM_BWPOSTMAN_REQUIRED'); ?>
					</p>
				</div>

				<button class="button validate save btn" type="button" onclick="return submitbutton('submit');">
					<?php echo Text::_('COM_BWPOSTMAN_BUTTON_EDIT'); ?>
				</button>
				<button class="button validate leave btn ml-2" type="button" onclick="return submitbutton('submitleave');">
					<?php echo Text::_('COM_BWPOSTMAN_BUTTON_LEAVEEDIT'); ?>
				</button>

				<input type="hidden" name="option" value="com_bwpostman" />
				<input type="hidden" name="task" value="save" />
				<input type="hidden" name="view" value="edit" />
				<input type="hidden" name="edit" value="" />
				<input type="hidden" name="id" value="<?php echo $this->subscriber->id; ?>" />
				<input type="hidden" name="name_field_obligation" value="<?php echo $this->params->get('name_field_obligation'); ?>" />
				<input type="hidden" name="firstname_field_obligation" value="<?php echo $this->params->get('firstname_field_obligation'); ?>" />
				<input type="hidden" name="special_field_obligation" value="<?php echo $this->params->get('special_field_obligation'); ?>" />
				<input type="hidden" name="show_name_field" value="<?php echo $this->params->get('show_name_field'); ?>" />
				<input type="hidden" name="show_firstname_field" value="<?php echo $this->params->get('show_firstname_field'); ?>" />
				<input type="hidden" name="show_special" value="<?php echo $this->params->get('show_special'); ?>" />
				<?php echo HtmlHelper::_('form.token'); ?>
			</form>

			<?php
			if ($this->params->get('show_boldt_link') === '1')
			{ ?>
				<p class="bwpm_copyright"><?php echo BwPostman::footer(); ?></p>
			<?php
			} ?>
		</div>
	</div>
</div>
<script type="text/javascript">
	jQuery(document).ready(function()
	{
		// Turn radios into btn-group
		jQuery('.radio.btn-group label').addClass('btn');
		jQuery(".btn-group label:not(.active)").click(function()
		{
			var label = jQuery(this);
			var input = jQuery('#' + label.attr('for'));

			if (!input.prop('checked'))
			{
				label.closest('.btn-group').find("label").removeClass('active btn-success btn-danger btn-primary');
				if (input.val() == '')
				{
					label.addClass('active btn-primary');
				}
				else if (input.val() == 0)
				{
					label.addClass('active btn-danger');
				}
				else
				{
					label.addClass('active btn-success');
				}
				input.prop('checked', true);
			}
		});
		jQuery(".btn-group input[checked=checked]").each(function()
		{
			if (jQuery(this).val() == '')
			{
				jQuery("label[for=" + jQuery(this).attr('id') + "]").addClass('active btn-primary');
			}
			else if (jQuery(this).val() == 0)
			{
				jQuery("label[for=" + jQuery(this).attr('id') + "]").addClass('active btn-danger');
			}
			else
			{
				jQuery("label[for=" + jQuery(this).attr('id') + "]").addClass('active btn-success');
			}
		});
	})
</script>
