<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman campaign controller for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import CONTROLLER object class
jimport('joomla.application.component.controllerform');

// Require helper class
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/helper.php');

/**
 * BwPostman Campaign Controller
 *
 * @since		1.0.1
 * @package 	BwPostman-Admin
 * @subpackage 	Campaigns
 */
class BwPostmanControllerCampaign extends JControllerForm
{
	/**
	 * @var    string  The prefix to use with controller messages.
	 * @since  1.0.4
	 */
	protected $text_prefix = 'COM_BWPOSTMAN_CAM';

	/**
	 * Constructor.
	 *
	 * @param  array  $config  An optional associative array of configuration settings.
	 *
	 * @since  1.0.1
	 * @see    JController
	 */
	public function __construct($config = array())
	{
		parent::__construct($config);
	
	}
	
	/**
	 * Method override to check if you can add a new record.
	 *
	 * @param   array  $data  An array of input data.
	 *
	 * @return  boolean
	 *
	 * @since   1.0.1
	 */
	protected function allowAdd($data = array())
	{
		$user	= JFactory::getUser();
		
		return ($user->authorise('core.create', 'com_bwpostman'));
	}

	/**
	 * Method override to check if you can edit a record.
	 *
	 * @param   array   $data  An array of input data.
	 * @param   string  $key   The name of the key for the primary key.
	 *
	 * @return  boolean
	 *
	 * @since   1.0.1
	 */
	protected function allowEdit($data = array(), $key = 'id')
	{
		// Initialise variables.
		$recordId	= (int) isset($data[$key]) ? $data[$key] : 0;
		$user		= JFactory::getUser();
		$userId		= $user->get('id');

		// Check general edit permission first.
		if ($user->authorise('core.edit', 'com_bwpostman.campaign'))
		{
			return true;
		}

		// Check specific edit permission.
		if ($user->authorise('core.edit', 'com_bwpostman.campaigns.' . $recordId))
		{
			return true;
		}

		// Fallback on edit.own.
		// First test if the permission is available.
		if ($user->authorise('core.edit.own', 'com_bwpostman.campaign.' . $recordId) || $user->authorise('core.edit.own', 'com_bwpostman'))
		{
			// Now test the owner is the user.
			$ownerId = (int) isset($data['created_by']) ? $data['created_by'] : 0;
			if (empty($ownerId) && $recordId)
			{
				// Need to do a lookup from the model.
				$record = $this->getModel()->getItem($recordId);

				if (empty($record))
				{
					return false;
				}
				$ownerId = $record->created_by;
			}

			// If the owner matches 'me' then do the test.
			if ($ownerId == $userId)
			{
				return true;
			}
		}
		return false;
	}

	/**
	 * Method to archive one or more campaigns and if the user want also the assigned newsletters
	 * --> campaigns-table: archive_flag = 1, set archive_date
	 *
	 * @access	public
	 * @return 	Redirect
	 */
	public function archive()
	{
		$jinput	= JFactory::getApplication()->input;
				
		// Check for request forgeries
		if (!JSession::checkToken()) jexit(JText::_('JINVALID_TOKEN'));
		
		$jinput	= JFactory::getApplication()->input;
		
		// If archive_nl = 1 the assigned newsletters shall be archived, too
		$archive_nl = $jinput->get('archive_nl');

		// Get the selected campaign(s)
		$cid = $jinput->get('cid', array(0), 'post', 'array');
		JArrayHelper::toInteger($cid);

		$n = count ($cid);

		$model = $this->getModel('campaign');
		if(!$model->archive($cid, 1, $archive_nl)) {
			if ($n > 1) {
				if ($archive_nl) {
					echo "<script> alert ('".JText::_('COM_BWPOSTMAN_CAMS_NL_ERROR_ARCHIVING', true)."'); window.history.go(-1); </script>\n";
				}
				else {
					echo "<script> alert ('".JText::_('COM_BWPOSTMAN_CAMS_ERROR_ARCHIVING', true)."'); window.history.go(-1); </script>\n";
				}
			}
			else {
				if ($archive_nl) {
					echo "<script> alert ('".JText::_('COM_BWPOSTMAN_CAM_NL_ERROR_ARCHIVING', true)."'); window.history.go(-1); </script>\n";
				}
				else {
					echo "<script> alert ('".JText::_('COM_BWPOSTMAN_CAM_ERROR_ARCHIVING', true)."'); window.history.go(-1); </script>\n";
				}
			}
		}
		else {
			if ($n > 1) {
				if ($archive_nl) {
					$msg = JText::_('COM_BWPOSTMAN_CAMS_NL_ARCHIVED');
				}
				else {
					$msg = JText::_('COM_BWPOSTMAN_CAMS_ARCHIVED');
				}
			}
			else {
				if ($archive_nl) {
					$msg = JText::_('COM_BWPOSTMAN_CAM_NL_ARCHIVED');
				}
				else {
					$msg = JText::_('COM_BWPOSTMAN_CAM_ARCHIVED');
				}
			}
			$link = JRoute::_('index.php?option=com_bwpostman&view=campaigns', false);
				
			$this->setRedirect($link, $msg);
		}
	}
}