<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman archive model for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import MODEL object class
jimport('joomla.application.component.modellist');

/**
 * BwPostman archive model
 * Provides a general view of all archived items
 *
 * @package		BwPostman-Admin
 * @subpackage	Archive
 */
class BwPostmanModelArchive extends JModelList
{
	/**
	 * Constructor
	 * --> handles the pagination of the single tabs
	 */
	public function __construct()
	{
		$app	= JFactory::getApplication();
		$layout = $app->input->get('layout','newsletters');
		
		if (empty($config['filter_fields'])) {
			switch ($layout) {
				case 'newsletters':
				default:
					$config['filter_fields'] = array(
						'id', 'a.id',
						'subject', 'a.subject',
						'mailing_date', 'a.mailing_date',
						'author', 'a.author',
						'campaign_id', 'a.campaign_id',
						'archive_date', 'a.archive_date',
						'access', 'a.access', 'access_level',
					);
					break;
				case 'subscribers':
					$config['filter_fields'] = array(
						'id', 'a.id',
						'archive_date', 'a.archive_date',
						'name', 'a.name',
						'firstname', 'a.firstname',
						'email', 'a.email',
						'status', 'a.status',
						'emailformat', 'a.emailformat',
						'mailinglists', 'a.mailinglists',
						'access', 'a.access', 'access_level',
					);
					break;
				case 'campaigns':
					$config['filter_fields'] = array(
						'id', 'a.id',
						'archive_date', 'a.archive_date',
						'newsletters', 'a.newsletters',
						'title', 'a.title',
						'description', 'a.description',
						'access', 'a.access', 'access_level',
					);
					break;
				case 'mailinglists':
					$config['filter_fields'] = array(
						'id', 'a.id',
						'archive_date', 'a.archive_date',
						'mailinglists', 'a.mailinglists',
						'subscribers', 'a.subscribers',
						'title', 'a.title',
						'description', 'a.description',
						'published', 'a.published',
						'access', 'a.access', 'access_level',
					);
					break;
			}
		}
		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   An optional ordering field.
	 * @param   string  $direction  An optional direction (asc|desc).
	 *
	 * @return  void
	 *
	 * @since   1.0.1
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app			= JFactory::getApplication();
		$orderMainCol	= '';

		// Adjust the context to support modal and tabbed layouts.
		if ($layout = $app->input->get('layout','newsletters'))
		{
			$this->context .= '.' . $layout;
		}

		$access = $this->getUserStateFromRequest($this->context . '.filter.access', 'filter_access');
		$this->setState('filter.access', $access);

		$published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		$status = $this->getUserStateFromRequest($this->context . '.filter.status', 'filter_status', '');
		$this->setState('filter.status', $status);

		$filter_mailinglist = $this->getUserStateFromRequest($this->context . '.filter.mailinglist', 'filter_mailinglist', '');
		$this->setState('filter.mailinglist', $filter_mailinglist);
		
		$author = $this->getUserStateFromRequest($this->context . '.filter.author', 'filter_author', '');
		$this->setState('filter.author', $author);
		
		$campaign = $this->getUserStateFromRequest($this->context . '.filter.campaign', 'filter_campaign', '');
		$this->setState('filter.campaign', $campaign);
		
		$mailing_date = $this->getUserStateFromRequest($this->context . '.filter.mailing_date', 'filter_mailing_date', '');
		$this->setState('filter.mailing_date', $mailing_date);
		
		$emailformat = $this->getUserStateFromRequest($this->context . '.filter.emailformat', 'filter_emailformat', '');
		
		if ($emailformat == NULL) $emailformat = '';
		$this->setState('filter.emailformat', $emailformat);
		
		switch ($layout) { // Which tab are we in?
			default:
			case "newsletters":
				$orderMainCol	= 'a.subject';
				
				$search = $this->getUserStateFromRequest($this->context . '.filter.search_nl', 'filter_search_nl');
				$this->setState('filter.search_nl', $search);
		
				$filtersearch = $this->getUserStateFromRequest($this->context . '.filter.search_filter_nl', 'filter_search_filter_nl');
				$this->setState('filter.search_filter_nl', $filtersearch);
				break;
				
			case "subscribers":
				$orderMainCol	= 'a.name';
				
				$search = $this->getUserStateFromRequest($this->context . '.filter.search_sub', 'filter_search_sub');
				$this->setState('filter.search_sub', $search);
		
				$filtersearch = $this->getUserStateFromRequest($this->context . '.filter.search_filter_sub', 'filter_search_filter_sub');
				$this->setState('filter.search_filter_sub', $filtersearch);
				break;
				
			case "campaigns":
				$orderMainCol	= 'a.title';
				
				$search = $this->getUserStateFromRequest($this->context . '.filter.search_cam', 'filter_search_cam');
				$this->setState('filter.search_cam', $search);
		
				$filtersearch = $this->getUserStateFromRequest($this->context . '.filter.search_filter_cam', 'filter_search_filter_cam');
				$this->setState('filter.search_filter_cam', $filtersearch);
				break;
				
			case "mailinglists":
				$orderMainCol	= 'a.title';
				
				$search = $this->getUserStateFromRequest($this->context . '.filter.search_ml', 'filter_search_ml');
				$this->setState('filter.search_ml', $search);
		
				$filtersearch = $this->getUserStateFromRequest($this->context . '.filter.search_filter_ml', 'filter_search_filter_ml');
				$this->setState('filter.search_filter_ml', $filtersearch);
				break;
		}
		// List state information.
		parent::populateState($orderMainCol, 'ASC');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param	string		$id	A prefix for the store id.
	 *
	 * @return	string		A store id.
	 * @since	1.0.1
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id	.= ':'.$this->getState('filter.search_nl');
		$id	.= ':'.$this->getState('filter.search_sub');
		$id	.= ':'.$this->getState('filter.search_cam');
		$id	.= ':'.$this->getState('filter.search_ml');
		$id	.= ':'.$this->getState('filter.search_filter_nl');
		$id	.= ':'.$this->getState('filter.search_filter_cam');
		$id	.= ':'.$this->getState('filter.search_filtersub');
		$id	.= ':'.$this->getState('filter.search_filter_ml');
		$id	.= ':'.$this->getState('filter.access');
		$id	.= ':'.$this->getState('filter.published');
		$id	.= ':'.$this->getState('filter.status');
		$id	.= ':'.$this->getState('filter.author');
		$id	.= ':'.$this->getState('filter.campaign');
		$id	.= ':'.$this->getState('filter.mailing_date');
		$id	.= ':'.$this->getState('filter.emailformat');
		$id	.= ':'.$this->getState('filter.mailinglist');
		
		return parent::getStoreId($id);
	}

	/**
	 * Method to build the MySQL query
	 *
	 * @access 	protected
	 * @return 	string Query
	 */
	protected function getListQuery()
	{
		$_db		= $this->_db;
		$query1		= $_db->getQuery(true);
		$query		= $_db->getQuery(true);
		$sub_query	= $_db->getQuery(true);
		$sub_query2	= $_db->getQuery(true);
		$user		= JFactory::getUser();
		$jinput		= JFactory::getApplication()->input;
		$layout		= $jinput->get('layout','newsletters');
		
		// Get the list ordering state
		$orderCol		= $this->state->get('list.ordering');
		$orderDirn		= $this->state->get('list.direction', 'asc');
		
		switch ($layout) {
			// We are in the newsletters_tab
			default:
			case "newsletters":
					$orderMainCol	= 'subject';
					
					$query->select($_db->quoteName('a')  . '.' . '*');
					$query->select($_db->quoteName('u')  . '.' . $_db->quoteName('name') . ' AS ' . $_db->quoteName('author'));
					$query->select($_db->quoteName('c')  . '.' . $_db->quoteName('title') . ' AS ' . $_db->quoteName('campaign'));
					$query->select($_db->quoteName('c')  . '.' . $_db->quoteName('archive_flag') . ' AS ' . $_db->quoteName('campaign_archive_flag'));
					$query->from($_db->quoteName('#__bwpostman_newsletters') . ' AS ' . $_db->quoteName('a'));
					$query->leftJoin($_db->quoteName('#__users') .' AS ' . $_db->quoteName('u') . ' ON ' . $_db->quoteName('u')  . '.' . $_db->quoteName('id') . ' =  ' . $_db->quoteName('a')  . '.' . $_db->quoteName('created_by'));
					$query->leftJoin($_db->quoteName('#__bwpostman_campaigns') .' AS ' . $_db->quoteName('c') . ' ON ' . $_db->quoteName('c')  . '.' . $_db->quoteName('id') . ' =  ' . $_db->quoteName('a')  . '.' . $_db->quoteName('campaign_id'));
				break;
					
			// We are in the subscribers_tab
			case "subscribers":
					$orderMainCol	= 'name';
						
					// Build sub query which counts all subscribed mailinglists of each subscriber
					$sub_query2->select($_db->quoteName('d')  . '.' . $_db->quoteName('id'));
					$sub_query2->from($_db->quoteName('#__bwpostman_mailinglists') . ' AS ' . $_db->quoteName('d'));
					$sub_query2->where($_db->quoteName('d')  . '.' . $_db->quoteName('archive_flag') . " = " . (int) 0);
					
					$sub_query->select('COUNT(' . $_db->quoteName('b')  . '.' . $_db->quoteName('mailinglist_id') . ') AS ' . $_db->quoteName('mailinglists'));
					$sub_query->from($_db->quoteName('#__bwpostman_subscribers_mailinglists') . ' AS ' . $_db->quoteName('b'));
					$sub_query->where($_db->quoteName('b')  . '.' . $_db->quoteName('subscriber_id') . " = " . $_db->quoteName('a')  . '.' . $_db->quoteName('id'));
					$sub_query->where($_db->quoteName('b')  . '.' . $_db->quoteName('mailinglist_id') . " IN (" . $sub_query2 . ')');
					
					$query->select($_db->quoteName('a')  . '.' . "*, IF (emailformat = '1','HTML','TEXT')" . ' AS ' . $_db->quoteName('emailformat'));
					$query->select('(' . $sub_query . ') AS ' . $_db->quoteName('mailinglists'));
					$query->from($_db->quoteName('#__bwpostman_subscribers') . ' AS ' . $_db->quoteName('a'));
				break;

			// We are in the campaigns_tab and we want to show all assigned newsletters
			// because we offer the option to unarchive not only the campaign but also the
			// assigned newsletters
			case "campaigns":
					$orderMainCol	= 'title';
						
					// Build sub query which counts all newsletters of each campaign
					$sub_query->select('COUNT(' . $_db->quoteName('n')  . '.' . $_db->quoteName('id') . ') AS ' . $_db->quoteName('newsletters'));
					$sub_query->from($_db->quoteName('#__bwpostman_newsletters') . ' AS ' . $_db->quoteName('n'));
					$sub_query->where($_db->quoteName('n')  . '.' . $_db->quoteName('campaign_id') . " = " . $_db->quoteName('a')  . '.' . $_db->quoteName('id'));
					
					$query->select($_db->quoteName('a')  . '.' . '*');
					$query->select('(' . $sub_query . ') AS ' . $_db->quoteName('newsletters'));
					$query->from($_db->quoteName('#__bwpostman_campaigns') . ' AS ' . $_db->quoteName('a'));

					// Join over the asset groups.
					$query->select('ag.title AS access_level');
					$query->join('LEFT', '#__viewlevels AS ag ON ag.id = a.access');
				break;
					
			// We are in the mailinglists_tab
			case "mailinglists":
					$orderMainCol	= 'title';
						
					// Build sub query which counts all subscribers of each mailinglist
					$sub_query2->select($_db->quoteName('d')  . '.' . $_db->quoteName('id'));
					$sub_query2->from($_db->quoteName('#__bwpostman_subscribers') . ' AS ' . $_db->quoteName('d'));
					$sub_query2->where($_db->quoteName('d')  . '.' . $_db->quoteName('archive_flag') . " = " . (int) 0);
					
					$sub_query->select('COUNT(' . $_db->quoteName('b')  . '.' . $_db->quoteName('subscriber_id') . ') AS ' . $_db->quoteName('subscribers'));
					$sub_query->from($_db->quoteName('#__bwpostman_subscribers_mailinglists') . ' AS ' . $_db->quoteName('b'));
					$sub_query->where($_db->quoteName('b')  . '.' . $_db->quoteName('mailinglist_id') . " = " . $_db->quoteName('a')  . '.' . $_db->quoteName('id'));
					$sub_query->where($_db->quoteName('b')  . '.' . $_db->quoteName('subscriber_id') . " IN (" . $sub_query2 . ')');
						
					$query->select($_db->quoteName('a')  . '.' . '*');
					$query->select('(' . $sub_query . ') AS ' . $_db->quoteName('subscribers'));
					$query->from($_db->quoteName('#__bwpostman_mailinglists') . ' AS ' . $_db->quoteName('a'));

					// Join over the asset groups.
					$query->select('ag.title AS access_level');
					$query->join('LEFT', '#__viewlevels AS ag ON ag.id = a.access');
				break;
		}

		// Filter by access level.
		if ($access = $this->getState('filter.access')) {
			$query->where($_db->quoteName('a')  . '.' . $_db->quoteName('access') . ' = ' . (int) $access);
		}
		
		// Implement View Level Access
		if (!$user->authorise('core.admin'))
		{
			$groups	= implode(',', $user->getAuthorisedViewLevels());
			$query->where('a.access IN ('.$groups.')');
		}

		$query->where($_db->quoteName('a')  . '.' . $_db->quoteName('archive_flag') . ' = ' . (int) 1);
		
		// Get the WHERE clause and ORDER-BY clause for the query
		$this->_buildQueryWhere($layout, $query);
		
		//sqlsrv change
		if($orderCol == 'access_level') $orderCol = 'ag.title';
		
		if ($orderCol == 'a.' . $orderMainCol) {
			$query->order($_db->quoteName('a')  . '.' . $_db->quoteName($orderMainCol) . ' ' . $orderDirn);
		}
		else {
			$query->order($_db->quoteName($orderCol) . ' ' . $orderDirn . ', ' . $_db->quoteName('a')  . '.' . $_db->quoteName($orderMainCol));
		}
		
		$_db->setQuery($query);

		return $query;
	}

	/**
	 * Method to build the WHERE clause
	 *
	 * @access 	protected
	 * @return 	string Query
	 */
	protected function _buildQueryWhere($layout, &$query)
	{
		$app	= JFactory::getApplication();
		$_db	= $this->_db;
		
		// Get the search string
		$where = '';

			switch ($layout) { // Which tab are we in?
			case "newsletters":
				$filtersearch	= $this->getState('filter.search_filter_nl');
				$search			= $_db->escape($this->getState('filter.search_nl'));
				
				// Get the author
				$filter_author = $this->getState('filter.author');
				if ($filter_author != '') {
					$query->where($_db->quoteName('a')  . '.' . $_db->quoteName('created_by') . " = " . (int)$filter_author);
				}

				// Get the campaign
				$filter_campaign = $this->getState('filter.campaign');
				
				if ($filter_campaign != '') {
					$query->where($_db->quoteName('a')  . '.' . $_db->quoteName('campaign_id') . " = " . (int)$filter_campaign);
				}
				break;
				
			case "subscribers":
				$filtersearch	= $this->getState('filter.search_filter_sub');
				$search			= $_db->escape($this->getState('filter.search_sub'));
				// Get the status
				$filter_status = $this->getState('filter.status');
				
				if ($filter_status != '') {
					$query->where($_db->quoteName('a')  . '.' . $_db->quoteName('status') . " = " . (int)$filter_status);
				}

				// Get the emailformat
				$filter_emailformat = $this->getState('filter.emailformat');
				
				if ($filter_emailformat != '') {
					$query->where($_db->quoteName('a')  . '.' . $_db->quoteName('emailformat') . " = " . (int)$filter_emailformat);
				}
				break;
				
			case "campaigns":
				$filtersearch	= $this->getState('filter.search_filter_cam');
				$search			= $_db->escape($this->getState('filter.search_cam'));
				break;
				
			case "mailinglists":
				$filtersearch	= $this->getState('filter.search_filter_ml');
				$search			= $_db->escape($this->getState('filter.search_ml'));
				// Get the state
				$filter_published = $this->getState('filter.published');
				
				if ($filter_published != '') {
					$query->where($_db->quoteName('a')  . '.' . $_db->quoteName('published') . " = " . (int) $filter_published);
				} 

				// Get the access level
				$filter_access = $this->getState('filter.access');

				if ($filter_access != '') {
					$query->where($_db->quoteName('a')  . '.' . $_db->quoteName('access') . " = " . (int)$filter_access);
				}
				break;
		}
		
		if ($search != '') {
			$fields = explode(',', $filtersearch);
				
			$where_array = array();

			$search = "%" . $_db->escape($search, true) . "%";
			foreach ($fields as $field) {
				$where_array[] = $_db->quoteName('a') . '.' . $_db->quoteName($field) . " LIKE " . $_db->Quote($search, false);
			}
			$where	= implode(' OR ', $where_array);
			$query->where('(' . $where .')');
		}
		return;
	}

	/**
	 * Method to load the filter information from State and pass them to the model
	 *
	 * @access	private
	 * @return 	array Filter
	 */
	public function getFilterLists()
	{
		// Get the filter information from cookie
		$app 	= JFactory::getApplication();
		$jinput	= JFactory::getApplication()->input;
		$_db	= $this->_db;

		// If we came from menue nothing is set, so we don't know which tab we are in --> default: 'newsletters'
		$tab = $jinput->get('layout','newsletters');

		// Build the key for the userState
		$key = 'com_bwpostman.archive.' . $tab;
		
		// Build the filter_search content for the newsletters_tab
		$filter_search_nl	= $app->getUserState            ($key.".filter.search_nl");

		// Build the filter_search select list for the subscribers_tab
		$filtersearch_nl 	= array ();
		$filtersearch_nl[]	= JHTML::_('select.option', 'subject', JText::_('COM_BWPOSTMAN_NL_FILTER_SEARCH_SUBJECT'));
		$filtersearch_nl[]	= JHTML::_('select.option', 'html_version', JText::_('COM_BWPOSTMAN_NL_FILTER_SEARCH_HTML'));
		$filtersearch_nl[] 	= JHTML::_('select.option', 'text_version', JText::_('COM_BWPOSTMAN_NL_FILTER_SEARCH_TEXT'));
		$filtersearch_nl[] 	= JHTML::_('select.option', 'html_version, text_version', JText::_('COM_BWPOSTMAN_NL_FILTER_SEARCH_HTMLTEXT'));
		$lists['filtersearch_nl'] = $filtersearch_nl;
		
		// Build the filter_search content for the subscribers_tab
		$filter_search_sub = $app->getUserState($key.".filter.search_sub");

		// Build the filter_search select list for the subscribers_tab
		$filtersearch_sub 	= array ();
		$filtersearch_sub[]	= JHTML::_('select.option', 'name', JText::_('COM_BWPOSTMAN_SUB_FILTER_SEARCH_NAME'));
		$filtersearch_sub[] = JHTML::_('select.option', 'email', JText::_('COM_BWPOSTMAN_SUB_FILTER_SEARCH_EMAIL'));
		$filtersearch_sub[] = JHTML::_('select.option', 'name, email', JText::_('COM_BWPOSTMAN_SUB_FILTER_SEARCH_NAMEEMAIL'));
		$lists['filtersearch_sub'] = $filtersearch_sub;

		// Build the filter_search content for the campaigns_tab
		$filter_search_cam = $app->getUserState($key.".filter.search_cam");
		// Build the filter_search select list for the campaigns_tab
		$filtersearch_cam 	= array ();
		$filtersearch_cam[]	= JHTML::_('select.option', 'title', JText::_('COM_BWPOSTMAN_CAM_FILTER_SEARCH_TITLE'));
		$filtersearch_cam[] = JHTML::_('select.option', 'description', JText::_('COM_BWPOSTMAN_CAM_FILTER_SEARCH_DESCRIPTION'));
		$filtersearch_cam[] = JHTML::_('select.option', 'title, description', JText::_('COM_BWPOSTMAN_CAM_FILTER_SEARCH_TITLEDESCRIPTION'));
		$lists['filtersearch_cam'] = $filtersearch_cam;

		// Build the filter_search content for the mailinglists_tab
		$filter_search_ml = $app->getUserState($key.".filter.search_ml");
		// Build the filter_search select list for the mailinglists_tab
		$filtersearch_ml 	= array ();
		$filtersearch_ml[]	= JHTML::_('select.option', 'title', JText::_('COM_BWPOSTMAN_ML_FILTER_SEARCH_TITLE'));
		$filtersearch_ml[] 	= JHTML::_('select.option', 'description', JText::_('COM_BWPOSTMAN_ML_FILTER_SEARCH_DESCRIPTION'));
		$filtersearch_ml[] 	= JHTML::_('select.option', 'title, description', JText::_('COM_BWPOSTMAN_ML_FILTER_SEARCH_TITLEDESCRIPTION'));
		$lists['filtersearch_ml'] = $filtersearch_ml;

		// Build the filter_author content for the newsletters_tab
		$filter_author = $app->getUserState($key."_filter_author");
		if (is_null($filter_author)) {
			$filter_author = '';
		}
		// Build the filter_author select list for the newsletters_tab
		$subQuery	= $_db->getQuery(true);
		$subQuery->select($_db->quoteName('nl') . '.' . $_db->quoteName('created_by'));
		$subQuery->from($_db->quoteName('#__bwpostman_newsletters') . ' AS ' . $_db->quoteName('nl'));
		$subQuery->where($_db->quoteName('nl') . '.' . $_db->quoteName('archive_flag') . ' = ' . (int) 1);
		
		$query	= $_db->getQuery(true);
		$query->select($_db->quoteName('u') . '.' . $_db->quoteName('id') . ' AS ' . $_db->quoteName('value'));
		$query->select($_db->quoteName('u') . '.' . $_db->quoteName('name') . ' AS ' . $_db->quoteName('text'));
		$query->from($_db->quoteName('#__users') . ' AS ' . $_db->quoteName('u'));
		$query->where($_db->quoteName('u') . '.' . $_db->quoteName('id') . ' IN (' . $subQuery . ')');
		
		$_db->setQuery($query);
		
		$author 			= array ();
		$author[]			= JHTML::_('select.option',  '', '- '. JText::_('COM_BWPOSTMAN_NL_FILTER_AUTHOR') .' -');
		$author 			= array_merge($author, $_db->loadObjectList());
		$lists['author']	= $author;

		// Build the filter_campaign content for the newsletters_tab
		$filter_campaign = $app->getUserState($key."_filter_campaign");
		if (is_null($filter_campaign)) {
			$filter_campaign = '';
		}
		// Build the filter_campaign select list for the newsletters_tab
		$subQuery	= $_db->getQuery(true);
		$subQuery->select($_db->quoteName('nl') . '.' . $_db->quoteName('campaign_id'));
		$subQuery->from($_db->quoteName('#__bwpostman_newsletters') . ' AS ' . $_db->quoteName('nl'));
		$subQuery->where($_db->quoteName('nl') . '.' . $_db->quoteName('archive_flag') . ' = ' . (int) 1);
		
		$query	= $_db->getQuery(true);
		$query->select($_db->quoteName('c') . '.' . $_db->quoteName('id') . ' AS ' . $_db->quoteName('value'));
		$query->select($_db->quoteName('c') . '.' . $_db->quoteName('title') . ' AS ' . $_db->quoteName('text'));
		$query->from($_db->quoteName('#__bwpostman_campaigns') . ' AS ' . $_db->quoteName('c'));
		$query->where($_db->quoteName('c') . '.' . $_db->quoteName('id') . ' IN (' . $subQuery . ')');
		
		$_db->setQuery($query);
		
		$campaign 	= array ();
		$campaign[] = JHTML::_('select.option',  '', '- '. JText::_('COM_BWPOSTMAN_NL_FILTER_CAMPAIGN') .' -');
		$campaign 	= array_merge($campaign, $_db->loadObjectList());
		$lists['campaign'] = $campaign;

		// Build the filter_status content for the subscribers_tab
		$filter_status = $app->getUserState($key."_filter_status");
		if (is_null($filter_status)) {
			$filter_status = '';
		}
		// Build the filter_status select list for the subscribers_tab
		$status 	= array();
		$status[]	= JHTML::_('select.option', '', '- '.JText::_('COM_BWPOSTMAN_ARC_SUB_FILTER_STATUS').' -');
		$status[] 	= JHTML::_('select.option', '0', JText::_('COM_BWPOSTMAN_ARC_SUB_UNCONFIRMED'));
		$status[] 	= JHTML::_('select.option', '1', JText::_('COM_BWPOSTMAN_ARC_SUB_CONFIRMED'));
		$status[]	= JHTML::_('select.option', '9', JText::_('COM_BWPOSTMAN_ARC_SUB_TEST'));
		$lists['status'] = $status;

		// Build the filter_emailformat content for the subscribers_tab
		$filter_emailformat = $app->getUserState($key."_filter_emailformat");
		if (is_null($filter_emailformat)) {
			$filter_emailformat = '';
		}
		// Build the filter_emailformat select list for the subscribers_tab
		$emailformat 	= array ();
		$emailformat[]	= JHTML::_('select.option', '', '- '.JText::_('COM_BWPOSTMAN_SUB_FILTER_EMAILFORMAT').' -');
		$emailformat[] 	= JHTML::_('select.option',  '0', JText::_('COM_BWPOSTMAN_TEXT'));
		$emailformat[] 	= JHTML::_('select.option',  '1', JText::_('COM_BWPOSTMAN_HTML'));
		$lists['emailformat'] = $emailformat;

		// Build the filter_emailformat content for the subscribers_tab
		$filter_access = $app->getUserState($key."_filter_access");
		if (is_null($filter_access)) {
			$filter_access = '';
		}
		// Build the select list for the group access
		$access 	= array ();
		$access[]	= JHTML::_('select.option', '', '- '.JText::_('COM_BWPOSTMAN_NL_FILTER_ACCESS').' -');
		$access[] 	= JHTML::_('select.option',  '1', JText::_('PUBLIC'));
		$access[] 	= JHTML::_('select.option',  '2', JText::_('REGISTERED'));
		$access[] 	= JHTML::_('select.option',  '3', JText::_('SPECIAL'));
		$lists['access'] = $access;

		// Build the state filter --> U = unpublished, P = Published
		$filter_state = $app->getUserStateFromRequest($key.'filter_state', 'filter_state', '', 'word');
		$lists['state']	= JHTML::_('grid.state',  $filter_state);

		return $lists;
	}

	/**
	 * Method to get the data of a single subscriber
	 *
	 * @param 	int Subscriber ID
	 * @return 	object Subscriber
	 */
	public function getSingleSubscriber ($sub_id = null)
	{
		$_db		= $this->_db;
		$query		= $_db->getQuery(true);
		$subQuery1	= $_db->getQuery(true);
		$subQuery2	= $_db->getQuery(true);
		$subQuery3	= $_db->getQuery(true);
		
		$subQuery1->select($_db->quoteName('u') . '.' . $_db->quoteName('name'));
		$subQuery1->from($_db->quoteName('#__users') . ' AS ' . $_db->quoteName('u'));
		$subQuery1->where($_db->quoteName('u') . '.' . $_db->quoteName('id') . ' = ' . $_db->quoteName('s') . '.' . $_db->quoteName('confirmed_by'));
		
		$subQuery2->select($_db->quoteName('u') . '.' . $_db->quoteName('name'));
		$subQuery2->from($_db->quoteName('#__users') . ' AS ' . $_db->quoteName('u'));
		$subQuery2->where($_db->quoteName('u') . '.' . $_db->quoteName('id') . ' = ' . $_db->quoteName('s') . '.' . $_db->quoteName('registered_by'));
		
		$subQuery3->select($_db->quoteName('u') . '.' . $_db->quoteName('name'));
		$subQuery3->from($_db->quoteName('#__users') . ' AS ' . $_db->quoteName('u'));
		$subQuery3->where($_db->quoteName('u') . '.' . $_db->quoteName('id') . ' = ' . $_db->quoteName('s') . '.' . $_db->quoteName('archived_by'));
		
		$query->select($_db->quoteName('s') . '.' . '*');
		$query->select(' IF(' . $_db->quoteName('s') . '.' . $_db->quoteName('confirmed_by') . ' = ' . (int) 0 . ', "User", (' . $subQuery1 . ' )) AS ' . $_db->quoteName('confirmed_by'));
		$query->select(' IF(' . $_db->quoteName('s') . '.' . $_db->quoteName('registered_by') . ' = ' . (int) 0 . ', "User", (' . $subQuery2 . ' )) AS ' . $_db->quoteName('registered_by'));
		$query->select('(' . $subQuery3 . ') AS ' . $_db->quoteName('archived_by'));
		$query->select(' IF( ' . $_db->quoteName('s') . '.' . $_db->quoteName('emailformat') . ' = ' . (int) 0 . ', "Text", "HTML" ) AS ' . $_db->quoteName('emailformat'));
		$query->from($_db->quoteName('#__bwpostman_subscribers') . ' AS ' . $_db->quoteName('s'));
		$query->where( $_db->quoteName('s') . '.' . $_db->quoteName('id') . ' = ' . (int) $sub_id);
		
		$_db->setQuery($query);
		$subscriber = $_db->loadObject();
			
		$query->clear();
		$query->select($_db->quoteName('mailinglist_id'));
		$query->from($_db->quoteName('#__bwpostman_subscribers_mailinglists'));
		$query->where($_db->quoteName('subscriber_id') . ' = ' . (int) $sub_id);
		
		$_db->setQuery($query);
		
		$mailinglist_id_values = $_db->loadColumn();

		if (!empty($mailinglist_id_values)) {
			$mailinglist_ids = implode (',', $mailinglist_id_values);
		} else {
			$mailinglist_ids = 0;
		}

		$query->clear();
		$query->select($_db->quoteName('id'));
		$query->select($_db->quoteName('title'));
		$query->select($_db->quoteName('description'));
		$query->select($_db->quoteName('archive_flag'));
		$query->from($_db->quoteName('#__bwpostman_mailinglists'));
		$query->where($_db->quoteName('id') . ' IN  (' . $mailinglist_ids . ')');
		$query->where($_db->quoteName('archive_flag') . ' = ' . (int) 0);

		$_db->setQuery($query);
		$subscriber->lists = $_db->loadObjectList();

		return $subscriber;
	}

	/**
	 * Method to get the data of a single campaign
	 *
	 * @param 	int Campaign ID
	 * @return 	object Campaign
	 */
	public function getSingleCampaign ($cam_id = null)
	{
		$_db	= $this->_db;
		$query	= $_db->getQuery(true);
		
		$query->select('*');
		$query->from($_db->quoteName('#__bwpostman_campaigns'));
		$query->where($_db->quoteName('id') . ' = ' . (int) $cam_id);		
		$_db->setQuery($query);
		
		$campaign = $_db->loadObject();

		// Get all assigned newsletters
		// --> we offer to unarchive not only the campaign but also the assigned newsletters,
		// that's why we have to show also the archived newsletters
		$query->clear();
		$query->select($_db->quoteName('id'));
		$query->select($_db->quoteName('subject'));
		$query->select($_db->quoteName('campaign_id'));
		$query->select($_db->quoteName('archive_flag'));
		$query->from($_db->quoteName('#__bwpostman_newsletters'));
		$query->where($_db->quoteName('campaign_id') . ' = ' . (int) $cam_id);

		$_db->setQuery($query);
		$campaign->newsletters = $_db->loadObjectList();

		return $campaign;
	}

	/**
	 * Method to get the data of a single Mailinglist
	 *
	 * @param 	int Mailinglist ID
	 * @return 	object Mailinglist
	 */
	public function getSingleMailinglist ($ml_id = null)
	{
		$_db	= $this->_db;
		$query	= $_db->getQuery(true);
		
		$query->select($_db->quoteName('a')  . '.' . '*');
		$query->from($_db->quoteName('#__bwpostman_mailinglists') . ' AS ' . $_db->quoteName('a'));
		$query->where($_db->quoteName('a')  . '.' . $_db->quoteName('id') . ' = ' . (int) $ml_id);
		// Join over the asset groups.
		$query->select($_db->quoteName('ag') . '.' . $_db->quoteName('title') . ' AS ' . $_db->quoteName('access_level'));
		$query->join('LEFT', $_db->quoteName('#__viewlevels') . ' AS ' . $_db->quoteName('ag') . ' ON ' . $_db->quoteName('ag') . '.' . $_db->quoteName('id') . ' = ' . $_db->quoteName('a') . '.' . $_db->quoteName('access'));
		
		$_db->setQuery($query);
		$mailinglist = $_db->loadObject();

		return $mailinglist;
	}
}
