<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman newsletterslists model for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import MODEL object class
jimport('joomla.application.component.modellist');

/**
 * BwPostman newsletters model
 * Provides a general view of all unsent and sent newsletters
 *
 * @package		BwPostman-Admin
 * @subpackage	Newsletters
 */
class BwPostmanModelNewsletters extends JModelList
{
	/**
	 * Constructor
	 * --> handles the pagination of the single tabs
	 */
	public function __construct()
	{
		if (empty($config['filter_fields'])) {
			$config['filter_fields'] = array(
				'id', 'a.id',
				'subject', 'a.subject',
				'description', 'a.description',
				'checked_out', 'a.checked_out',
				'checked_out_time', 'a.checked_out_time',
				'published', 'a.published',
				'campaign', 'a.campaign',
				'created_date', 'a.created_date',
				'modified_time', 'a.modified_time',
				'editor', 'a.editor',
				'author', 'a.author',
				'mailing_date', 'a.mailing_date',
				'created_by', 'a.created_by',
				'publish_up', 'a.publish_up',
				'publish_down', 'a.publish_down',
				'ordering', 'a.ordering',
			);
		}
		parent::__construct($config);
	}

	/**
	 * Method to auto-populate the model state.
	 *
	 * Note. Calling getState in this method will result in recursion.
	 *
	 * @param   string  $ordering   An optional ordering field.
	 * @param   string  $direction  An optional direction (asc|desc).
	 *
	 * @return  void
	 *
	 * @since   1.0.1
	 */
	protected function populateState($ordering = null, $direction = null)
	{
		$app = JFactory::getApplication();

		// Adjust the context to support modal layouts.
		if ($layout = $app->input->get('layout'))
		{
			$this->context .= '.' . $layout;
		}

		$search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
		$this->setState('filter.search', $search);

		$filtersearch = $this->getUserStateFromRequest($this->context . '.filter.search_filter', 'filter_search_filter');
		$this->setState('filter.search_filter', $filtersearch);
		
		$published = $this->getUserStateFromRequest($this->context . '.filter.published', 'filter_published', '');
		$this->setState('filter.published', $published);

		$author = $this->getUserStateFromRequest($this->context . '.filter.author', 'filter_author', '');
		$this->setState('filter.author', $author);

		$campaign = $this->getUserStateFromRequest($this->context . '.filter.campaign', 'filter_campaign', '0');
		$this->setState('filter.campaign', $campaign);

		$mailing_date = $this->getUserStateFromRequest($this->context . '.filter.mailing_date', 'filter_mailing_date', '');
		$this->setState('filter.mailing_date', $mailing_date);

		// List state information.
		parent::populateState('a.subject', 'asc');
	}

	/**
	 * Method to get a store id based on model configuration state.
	 *
	 * This is necessary because the model is used by the component and
	 * different modules that might need different sets of data or different
	 * ordering requirements.
	 *
	 * @param	string		$id	A prefix for the store id.
	 *
	 * @return	string		A store id.
	 * @since	1.0.1
	 */
	protected function getStoreId($id = '')
	{
		// Compile the store id.
		$id	.= ':'.$this->getState('filter.search');
		$id	.= ':'.$this->getState('filter.search_filter');
		$id	.= ':'.$this->getState('filter.published');
		$id	.= ':'.$this->getState('filter.author');
		$id	.= ':'.$this->getState('filter.campaign');
		$id	.= ':'.$this->getState('filter.description');
		
		return parent::getStoreId($id);
	}

	/**
	 * Method to get the queue data
	 *
	 * @access	public
	 * @return 	object Queue-data
	 */
	public function getQueue()
	{
		$_db		= $this->_db;
		$query		= $_db->getQuery(true);
		$subQuery	= $_db->getQuery(true);
		$subQuery2	= $_db->getQuery(true);
		
		$subQuery->select('DISTINCT' . $_db->quoteName('c')  . '.' . $_db->quoteName('subject'));
		$subQuery->from($_db->quoteName('#__bwpostman_sendmailcontent')  . ' AS ' . $_db->quoteName('c'));
		$subQuery->where($_db->quoteName('c')  . '.' . $_db->quoteName('id') .' = ' . $_db->quoteName('q')  . '.' . $_db->quoteName('content_id'));
		
		$subQuery2->select($_db->quoteName('n')  . '.'  . 'description');
		$subQuery2->from($_db->quoteName('#__bwpostman_newsletters')  . ' AS ' . $_db->quoteName('n'));
		$subQuery2->where($_db->quoteName('n')  . '.' . $_db->quoteName('id') .' = ' . $_db->quoteName('q')  . '.' . $_db->quoteName('content_id'));
		
		$query->select($_db->quoteName('q')  . '.'  . '*');
		$query->select('(' . $subQuery . ') AS ' . $_db->quoteName('subject'));
		$query->select('(' . $subQuery2 . ') AS ' . $_db->quoteName('description'));
		$query->from($_db->quoteName('#__bwpostman_sendmailqueue')  . ' AS ' . $_db->quoteName('q'));
		$query->order($_db->quoteName('q')  . '.' . $_db->quoteName('id'));
		
		$_db->setQuery($query);
		$queue = $_db->loadObjectList();

		return $queue;
	}

	/**
	 * Method to get the queue data
	 *
	 * @access	public
	 * @return 	object Queue-data
	 */
	public function getAuthorList()
	{
		$app		= JFactory::getApplication();
		$date		= JFactory::getDate();
		$_db		= $this->_db;
		$query		= $_db->getQuery(true);
		$sub_query	= $_db->getQuery(true);
		
		// Build the subquery
		$sub_query->select('nl.created_by');
		$sub_query->from('#__bwpostman_newsletters AS nl');
		$sub_query->where('nl.mailing_date != ' . $_db->Quote('0000-00-00 00:00:00'));
		$sub_query->where('nl.archive_flag = ' . (int) 0);
		
		$query->select('u.id AS value');
		$query->select('u.name AS text');
		$query->from('#__users AS u');
		$query->where('u.id IN (' . $sub_query . ')');

		$_db->setQuery($query);
		$sent_authors	= $_db->loadObjectList();		
		
		$author_sent 	= array ();
		$author_sent[] 	= JHTML::_('select.option',  '-1', '- '. JText::_('COM_BWPOSTMAN_NL_FILTER_AUTHOR') .' -');
		$_db->setQuery($query);
		$author_sent	= array_merge($author_sent, $_db->loadObjectList());

		$author_sent 		= array_merge($author_sent, $sent_authors);

		return $author_sent;
	}
	
		
	/**
	 * Method to get the campains list
	 *
	 * @access	public
	 * @return 	array campaigns list
	 */
	public function getCampaignList()
	{
		$app		= JFactory::getApplication();
		$_db		= $this->_db;
		$query		= $_db->getQuery(true);
		$sub_query	= $_db->getQuery(true);
		
		// Build the filter_campaign_sent select list
		// Build the subquery
		$sub_query->select('nl.campaign_id');
		$sub_query->from('#__bwpostman_newsletters AS nl');
		$sub_query->where('nl.mailing_date != ' . $_db->Quote('0000-00-00 00:00:00'));
		$sub_query->where('nl.archive_flag = ' . (int) 0);
		
		$query->select('c.id AS value');
		$query->select('c.title AS text');
		$query->from('#__bwpostman_campaigns AS c');
		$query->where('c.archive_flag = 0');
		$query->where('c.id IN (' . $sub_query . ')');

		$_db->setQuery($query);
		$sent_campaigns	= $_db->loadObjectList();		
		
		$campaign_sent 		= array ();
		$campaign_sent[]	= JHTML::_('select.option',  '0', '- '. JText::_('COM_BWPOSTMAN_NL_FILTER_CAMPAIGN') .' -');
		$campaign_sent 		= array_merge($campaign_sent, $sent_campaigns);

		return $campaign_sent;
	}

	/**
	 * Method to build the MySQL query
	 *
	 * @access 	private
	 * @return 	string Query
	 */
	protected function getListQuery()
	{
		$_db	= $this->_db;
		$app	= JFactory::getApplication();
		$jinput	= JFactory::getApplication()->input;
		$query	= $_db->getQuery(true);
		
		//Get the tab in which we are for subquery
		$tab	= JFactory::getApplication()->getUserState('com_bwpostman.newsletters.tab', 'unsent');

		switch ($tab) {
			case ("unsent"):
				$tab_int	= ' = ';
				break;
			case ("sent"):
				$tab_int	= ' <> ';
				break;
			case ("queue"):
				$tab_int	= ' = ';
				break;
		}
			
		// Build sub query which shows the data depending on the tab which we are in
		$layout = $jinput->get('layout','unsent');
		$subQueryTab = '';
		
		// Get the WHERE clause and ORDER-BY clause for the query

		$query->select(
			$this->getState(
				'list.select',
				'a.id, a.subject, a.description, a.checked_out, a.checked_out_time' .
				', a.published, a.created_date, a.created_by, a.modified_time'
			)
		);
		$query->select('a.mailing_date');
		$query->select('a.description');
		$query->select('c.title AS campaign');
		$query->from('#__bwpostman_newsletters AS a');
		$query->leftJoin('#__bwpostman_campaigns AS c ON c.id = a.campaign_id');
		$query->where('a.archive_flag = 0');
		
		// Join over the users for the checked out user.
		$query->select('uc.name AS editor');
		$query->join('LEFT', '#__users AS uc ON uc.id=a.checked_out');
		
		// Join over the users for the author.
		$query->select('ua.name AS author');
		$query->join('LEFT', '#__users AS ua ON ua.id = a.created_by');
		
		// Filter by campaign
		if ($campaign = $this->getState('filter.campaign')) {
			$query->where('a.campaign_id = ' . (int) $campaign);
		}
		
		// Filter by author
		if (($author = $this->getState('filter.author')) && ($author != -1)) {
			$query->where('a.created_by = ' . (int) $author);
		}
		
		// Filter by published state
		$published = $this->getState('filter.published');
		if (is_numeric($published)) {
			$query->where('a.published = ' . (int) $published);
		}
		elseif ($published === '') {
			$query->where('(a.published = 0 OR a.published = 1)');
		}
		
		// Filter by mailing date
		$query->where('a.mailing_date' . $tab_int . "'0000-00-00 00:00:00'");
		
		// Filter by archive state
		$query->where('a.archive_flag = ' . (int) 0);
		
		// Filter by search word.
		$filtersearch	= $this->getState('filter.search_filter');
		$search			= $_db->escape($this->getState('filter.search'), true);
		
		if (!empty($search)) {
			$search			= '%' . $search . '%';
			switch ($filtersearch) {
				case 'subject':
						$query->where('a.subject LIKE ' . $_db->Quote($search));
					break;
				case 'description':
						$query->where('a.description LIKE ' . $_db->Quote($search));
					break;
				case 'subject_description':
						$query->where('(a.subject LIKE ' . $_db->Quote($search). 'OR a.description LIKE ' . $_db->Quote($search, false) . ')');
					break;
				case 'html_text_version':
						$query->where('(a.html_version LIKE ' . $_db->Quote($search, false) . 'OR a.text_version LIKE ' . $_db->Quote($search, false) . ')');
					break;
				case 'text_version':	
						$query->where('a.text_version LIKE ' . $_db->Quote($search. false));
					break;
				case 'html_version':	
						$query->where('a.html_version LIKE ' . $_db->Quote($search, false));
					break;
				default:	
			}
		}
		
		// Add the list ordering clause.
		$orderCol	= $this->state->get('list.ordering', 'a.subject');
		$orderDirn	= $this->state->get('list.direction', 'asc');
		
		//sqlsrv change
		if($orderCol == 'modified_time')
			$orderCol = 'a.modified_time';
		
		$query->order($_db->escape($orderCol.' '.$orderDirn));
		$_db->setQuery($query);
		return $query;
	}
}