<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman archive campaigns template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Load the tooltip behavior for the notes
JHTML::_('behavior.tooltip');

// Load the modal behavior for the campaign preview
if (version_compare(JVERSION,'3.0.0','>=')) {
  JHTML::_('behavior.modal');
}
else {
	JHTML::_('behavior.modal');
	JHTML::_('behavior.modal', 'a.popup');
}

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

//Set context and layout state for filters
$this->context	= 'archive.campaigns';
$tab			= JFactory::getApplication()->setUserState($this->context . '.tab', 'campaigns');

/**
 * BwPostman Archived Campaigns Layout
 *
 * @package 	BwPostman-Admin
 * @subpackage 	Archive
 */
?>

<script type="text/javascript">
/* <![CDATA[ */
	function confirmUnarchive(unarchive_value)  // Get the selected value from modalbox
	{ 
		document.adminForm.unarchive_nl.value = unarchive_value;
		Joomla.submitbutton('archive.unarchive');
	}

	function confirmDelete(delete_value)  // Get the selected value from modalbox
	{ 
		document.adminForm.remove_nl.value = delete_value;
		Joomla.submitbutton('archive.delete');
	}
/* ]]> */		
</script>

<div id="bwp_view_lists">
	<form action="<?php echo $this->request_url; ?>" method="post" name="adminForm" id="adminForm" class="form-inline">
		<fieldset id="filter-bar" class="well well-small">
			<div class="filter-search fltlft pull-left">
				<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('SEARCH'); ?></label>
				<select name="filter_search_filter_cam" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->lists['filtersearch_cam'], 'value', 'text', $this->state->get('filter.search_filter_cam')) ; ?>
				</select>
				<input type="text" name="filter_search_cam" id="filter_search_cam" value="<?php echo $this->escape($this->state->get('filter.search_cam')); ?>" title="<?php echo JText::_('COM_BWPOSTMAN_FILTER_SEARCH_DESC'); ?>" />
				
				<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
				<button type="button" class="btn" onclick="document.getElementById('filter_search_cam').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			</div>
			<div class="filter-select fltrt pull-right">
		        <?php
		        if (version_compare(JVERSION,'3.0.0','>=')) {
		          echo $this->pagination->getLimitBox();
				    }
		        ?>
			</div>
		</fieldset>

		<div class="row-fluid">
			<table class="adminlist table table-striped">
				<tbody>
					<tr>
						<td valign="top" width="90%">
							<ul class="bwp_tabs">
								<li class="closed"><!-- We need to use the setAttribute-function because of the IE -->
									<button onclick="layout.setAttribute('value','newsletters');this.form.submit();" class="buttonAsLink"><?php echo JText::_('COM_BWPOSTMAN_ARC_NLS'); ?></button>
								</li>
								<li class="closed">
									<button onclick="layout.setAttribute('value','subscribers');this.form.submit();" class="buttonAsLink"><?php echo JText::_('COM_BWPOSTMAN_ARC_SUBS'); ?></button>
								</li>
								<li class="open">
									<button onclick="layout.setAttribute('value','campaigns');this.form.submit();" class="buttonAsLink_open"><?php echo JText::_('COM_BWPOSTMAN_ARC_CAMS'); ?></button>
								</li>
								<li class="closed">
									<button onclick="layout.setAttribute('value','mailinglists');this.form.submit(); "class="buttonAsLink"><?php echo JText::_('COM_BWPOSTMAN_ARC_MLS'); ?></button>
								</li>
							</ul>
			
							<div class="current">
								<table class="adminlist">
									<thead>
										<tr>
											<th width="30" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'NUM', 'a.id', $listDirn, $listOrder); ?></th>
											<th width="30" nowrap="nowrap"><input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" /></th>
											<th width="250"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_ARC_CAM_TITLE', 'a.title', $listDirn, $listOrder); ?></th>
											<th><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_ARC_CAM_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?></th>
											<th width="180"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_CAM_NL_NUM', 'newsletters', $listDirn, $listOrder); ?></th>
											<th width="150"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_ARC_ARCHIVE_DATE', 'a.archive_date', $listDirn, $listOrder); ?></th>
										</tr>
									</thead>
									<tfoot>
										<tr>
											<td colspan="6"><?php echo $this->pagination->getListFooter(); ?></td>
										</tr>
									</tfoot>
									<tbody>
									<?php 
									if (count($this->items) > 0) {
										foreach ($this->items as $i => $item) : 
											$canCheckin	= $user->authorise('core.manage',		'com_bwpostman') || $item->checked_out == $userId || $item->checked_out == 0;
											$canEdit	= $user->authorise('core.edit',			'com_bwpostman.newsletter.'.$item->id);
											$canEditOwn	= $user->authorise('core.edit.own',		'com_bwpostman.newsletter.'.$item->id) && $item->created_by == $userId;
											$canChange	= $user->authorise('core.edit.state',	'com_bwpostman.newsletter.'.$item->id) && $canCheckin;
											?>
											<tr class="row<?php echo $i % 2; ?>">
												<td align="center"><?php echo $item->id; ?></td>
												<td align="center"><?php echo JHtml::_('grid.id', $i, $item->id); ?></td>
												<td>
													<span class="editlinktip hasTip" title="<?php echo JText::_('COM_BWPOSTMAN_ARC_SHOW_CAM');?>::<?php echo $this->escape($item->title); ?>">
														<a class="modal" href="<?php echo JRoute::_('index.php?option=com_bwpostman&view=archive&format=raw&layout=campaign_modal&cam_id='. $item->id);?>" rel="{handler: 'iframe', size: {x: 650, y: 450}}"><?php echo $item->title;?></a>&nbsp;
													</span>
												</td>
												<td><?php echo $item->description; ?></td>
												<td align="center"><?php echo $item->newsletters; ?></td>
												<td align="center"><?php echo JHtml::date($item->archive_date, JText::_('BW_DATE_FORMAT_LC5')); ?></td>
											</tr>
										<?php endforeach;
										}
										else { ?>
											<tr class="row1">
												<td colspan="6"><strong><?php echo JText::_('COM_BWPOSTMAN_NO_DATA'); ?></strong></td>
											</tr><?php
										}
									?>
									</tbody>
								</table>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
			
			<input type="hidden" name="task" value="" />
			<input type="hidden" name="boxchecked" value="0" />
			<input type="hidden" name="unarchive_nl" value="0" />
			<input type="hidden" name="remove_nl" value="0" />
			<input type="hidden" name="layout" value="campaigns" /><!-- value can change if one clicks on another tab -->
			<input type="hidden" name="tab" value="campaigns" /><!-- value never changes -->
			<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
			<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
			<?php echo JHTML::_('form.token'); ?>
		</div>
		<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
	</form>
</div>