<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman single campaigns form template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Load the tooltip behavior for the notes
JHTML::_('behavior.tooltip');
JHTML::_('behavior.keepalive');

//Load tabs behavior for the Tabs
jimport('joomla.html.html.tabs');
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/bwtabs.php');

// Load the modal behavior for the newsletter preview
JHTML::_('behavior.modal', 'a.popup');

$tab_options = array(
    'onActive' => 'function(title, description){
        description.setStyle("display", "block");
        title.addClass("open").removeClass("closed");
    }',
    'onBackground' => 'function(title, description){
        description.setStyle("display", "none");
        title.addClass("closed").removeClass("open");
    }',
    'useCookie' => 'true', // note the quotes around true, since it must be a string. But if you put false there, you must not use qoutes otherwise JHtmlTabs will handle it as true
);

/**
 * BwPostman Single Campaign Layout
 *
 * @package 	BwPostman-Admin
 * @subpackage 	Campaigns
 */

?>

<script type="text/javascript">
/* <![CDATA[ */
	Joomla.submitbutton = function (pressbutton) {
	
		var form = document.adminForm;
		
		if (pressbutton == 'campaign.cancel') {
			submitform(pressbutton);
			return;
		}

		// Valdiate input fields
		if (form.jform_title.value == ""){
			alert("<?php echo JText::_('COM_BWPOSTMAN_CAM_ERROR_TITLE', true); ?>");
		} else {
			submitform(pressbutton);
		}
	}
/* ]]> */
</script>

<div id="bwp_editform" class="well well-small">
	<?php
		if ($this->queueEntries) {
			JFactory::getApplication()->enqueueMessage(JText::_('COM_BWPOSTMAN_ENTRIES_IN_QUEUE'), 'warning');
 		}
	?>
	<form action="<?php echo JRoute::_('index.php?option=com_bwpostman&layout=default&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="adminForm" class="form-horizontal">
		<fieldset class="adminform">
			<legend><?php echo empty($this->item->id) ? JText::_('COM_BWPOSTMAN_NEW_CAM') : JText::sprintf('COM_BWPOSTMAN_EDIT_CAM', $this->item->id); ?></legend>
			<div class="width-60 fltlft span8 control-group">
				<ul class="adminformlist unstyled">
					<?php if (isset($this->item->err_code)) if (($this->item->err_code == 101) || ($this->item->err_code == 102)) ?>
					<li>
						<?php echo $this->form->getLabel('title'); ?>
						<div class="controls"><?php echo $this->form->getInput('title'); ?></div>
					</li>
		
					<?php if (isset($this->item->err_code)) if (($this->item->err_code == 101) || ($this->item->err_code == 102)) ?>
					<li>
						<?php echo $this->form->getLabel('description'); ?>
						<div class="controls"><?php echo $this->form->getInput('description'); ?></div>
					</li>
		
					<li>
						<?php echo $this->form->getLabel('access'); ?>
						<div class="controls"><?php echo $this->form->getInput('access'); ?></div>
					</li>
		
					<li>
						<?php echo $this->form->getLabel('published'); ?>
						<div class="controls"><?php echo $this->form->getInput('published'); ?></div>
					</li>
				</ul>
			</div>
				
			<div class="width-40 fltrt span4 control-group">
				<ul class="adminformlist width_50 unstyled">
					<?php if (empty($this->item->campaign_id)) 
							$this->form->setFieldAttribute('campaign_id', 'type', 'hidden');
					?>
					<li>
						<?php echo $this->form->getLabel('campaign_id'); ?>
						<div class="controls"><?php echo $this->form->getInput('campaign_id'); ?></div>
					</li>
					
					<li>
						<?php echo $this->form->getLabel('created_by'); ?>
						<div class="controls"><?php echo $this->form->getInput('created_by'); ?></div>
					</li>
		
					<li>
						<?php echo $this->form->getLabel('created_date'); ?>
						<div class="controls"><?php echo $this->form->getInput('created_date'); ?></div>
					</li>
		
					<li>
						<?php echo $this->form->getLabel('modified_by'); ?>
						<div class="controls"><?php echo $this->form->getInput('modified_by'); ?></div>
					</li>
		
					<li>
						<?php echo $this->form->getLabel('modified_time'); ?>
						<div class="controls"><?php echo $this->form->getInput('modified_time'); ?></div>
					</li>
				</ul>
			</div>
			<div class="clr"></div>
		</fieldset>
		<p><span class="required_description"><?php echo JText::_('COM_BWPOSTMAN_REQUIRED'); ?></span></p>
		
		<?php
		//Show tabs with sent and unsent newsletters if we edit a campaign
		if (!empty($this->item->id)) { ?>
			<fieldset id="bwp_view_lists" class="adminform">
				<legend><?php echo JText::_('COM_BWPOSTMAN_CAM_ASSIGNED_NL'); ?></legend>
				<?php
				//Show no tabs if there is no newsletter assigned
				if ((empty($this->newsletters->sent)) && (empty($this->newsletters->unsent))) {
					echo JText::_('COM_BWPOSTMAN_CAM_NO_ASSIGNED_NL');
					//Show tabs
				}
				else {
					echo JHtmlBwTabs::start('bwp_cam_assigned_nl-pane', $tab_options);
						
					//Show tab with unsent newsletters only if there are some assigned unsent newsletters
					if (!empty($this->newsletters->unsent)): {
						$title = JText::_('COM_BWPOSTMAN_NL_UNSENT');
						echo JHtmlBwTabs::panel( $title, 'unsent', ''); 
						?>
		
					<table class="adminlist" width="100%">
						<thead>
							<tr>
								<th width="30"><?php echo JText::_('NUM'); ?></th>
								<th><?php echo JText::_('SUBJECT'); ?></th>
								<th width="150"><?php echo JText::_('COM_BWPOSTMAN_NL_LAST_MODIFICATION_DATE'); ?></th>
								<th width="150"><?php echo JText::_('AUTHOR'); ?></th>
							</tr>
						</thead>
						<tbody>
						<?php
							$k = 0;
						
							$newsletters_unsent = $this->newsletters->unsent;
							for ($i=0, $n=count($newsletters_unsent); $i < $n; $i++)
						
							{
								$item = &$newsletters_unsent[$i];
						
								$link_html = 'index.php?option=com_bwpostman&amp;view=newsletter&amp;format=raw&amp;layout=newsletter_html_modal&amp;task=insideModal&amp;nl_id='. $item->id;
								$link_text = 'index.php?option=com_bwpostman&amp;view=newsletter&amp;format=raw&amp;layout=newsletter_text_modal&amp;task=insideModal&amp;nl_id='. $item->id;
								?>
								<tr class="<?php echo "item$k"; ?>">
									<td align="center"><?php echo $i+1; ?></td>
									<td><?php echo $item->subject; ?>&nbsp;&nbsp; <span
										class="cam_preview"> <span class="editlinktip hasTip"
										title="<?php echo JText::_('COM_BWPOSTMAN_NL_SHOW_HTML');?>::<?php echo $this->escape($item->subject); ?>">
										<?php echo '<a class="popup" href="'.$link_html.'" rel="{handler: \'iframe\', size: {x: 600, y: 450}}">'.JText::_('COM_BWPOSTMAN_HTML_NL').'</a>'; ?>&nbsp;
									</span> <span class="editlinktip hasTip"
										title="<?php echo JText::_('COM_BWPOSTMAN_NL_SHOW_TEXT');?>::<?php echo $this->escape($item->subject); ?>">
										<?php echo '<a class="popup" href="'.$link_text.'" rel="{handler: \'iframe\', size: {x: 600, y: 450}}">'.JText::_('COM_BWPOSTMAN_TEXT_NL').'</a>'; ?>
									</span> </span></td>
									<td align="center"><?php echo JHtml::date($item->modified_time, JText::_('BW_DATE_FORMAT_LC5')); ?></td>
									<td align="center"><?php echo $item->author; ?></td>
								</tr>
								<?php
								$k = 1 - $k;
							}
						?>
						</tbody>
					</table>
				<?php
				} endif;
				//End: Show tab with unsent newsletters only if there are some assigned unsent newsletters
	
				//Show tab with sent newsletters only if there are some assigned unsent newsletters
				if (!empty($this->newsletters->sent)) : {
					$title = JText::_('COM_BWPOSTMAN_NL_SENT');
					echo JHtmlBwTabs::panel( $title, 'sent', ''); 
					?>
		
				<table class="adminlist" width="100%">
					<thead>
						<tr>
							<th width="30"><?php echo JText::_('NUM'); ?></th>
							<th><?php echo JText::_('SUBJECT'); ?></th>
							<th width="150"><?php echo JText::_('COM_BWPOSTMAN_NL_MAILING_DATE'); ?></th>
							<th width="150"><?php echo JText::_('AUTHOR'); ?></th>
							<th width="150"><?php echo JText::_('PUBLISHED'); ?></th>
						</tr>
					</thead>
					<tbody>
					<?php
						$k = 0;
					
						$newsletters_sent = $this->newsletters->sent;
						for ($i=0, $n=count($newsletters_sent); $i < $n; $i++)
						{
							$item		= &$newsletters_sent[$i];
							$link_html	= 'index.php?option=com_bwpostman&amp;view=newsletter&amp;format=raw&amp;layout=newsletter_html_modal&amp;task=insideModal&amp;nl_id='. $item->id;
							$link_text	= 'index.php?option=com_bwpostman&amp;view=newsletter&amp;format=raw&amp;layout=newsletter_text_modal&amp;task=insideModal&amp;nl_id='. $item->id;
							?>
							<tr class="<?php echo "item$k"; ?>">
								<td align="center"><?php echo $i+1; ?></td>
								<td><?php echo $item->subject; ?>&nbsp;&nbsp; 
									<span class="cam_preview">
										<span class="editlinktip hasTip"
											title="<?php echo JText::_('COM_BWPOSTMAN_NL_SHOW_HTML');?>::<?php echo $this->escape($item->subject); ?>">
											<?php echo '<a class="popup" href="'.$link_html.'" rel="{handler: \'iframe\', size: {x: 600, y: 450}}">'.JText::_('COM_BWPOSTMAN_HTML_NL').'</a>'; ?>&nbsp;
											</span> 
										<span class="editlinktip hasTip"
											title="<?php echo JText::_('COM_BWPOSTMAN_NL_SHOW_TEXT');?>::<?php echo $this->escape($item->subject); ?>">
											<?php echo '<a class="popup" href="'.$link_text.'" rel="{handler: \'iframe\', size: {x: 600, y: 450}}">'.JText::_('COM_BWPOSTMAN_TEXT_NL').'</a>'; ?>
										</span>
									</span>
								</td>
					
								<td align="center"><?php echo JHtml::date($item->mailing_date, JText::_('BW_DATE_FORMAT_LC5')); ?></td>
								<td align="center"><?php echo $item->author; ?></td>
								<td align="center"><?php if ($item->published) { echo JText::_('COM_BWPOSTMAN_YES'); } else { echo JText::_('COM_BWPOSTMAN_NO');}?>
								</td>
							</tr>
							<?php
							$k = 1 - $k;
						}
					?>
					</tbody>
				</table>
				<?php
				} endif;
				//Show tab with sent newsletters only if there are some assigned unsent newsletters
				echo JHtmlBwTabs::end();
				}
				//End: Show no tabs if there is no newsletter assigned
				?>
			</fieldset>
		<?php 
		}
		//End: Show tabs with sent and unsent newsletters if we edit this campaign
		?>
		<div class="well well-small">
			<?php if ($this->canDo->get('core.admin')): ?>
				<div class="fltlft">
					<?php echo JHtml::_('sliders.start', 'permissions-sliders-'.$this->item->id, array('useCookie'=>1)); ?>
					<?php echo JHtml::_('sliders.panel', JText::_('COM_BWPOSTMAN_CAM_FIELDSET_RULES'), 'access-rules'); ?>
					<fieldset class="panelform">
						<?php echo $this->form->getLabel('rules'); ?>
						<?php echo $this->form->getInput('rules'); ?>
					</fieldset>
					<?php echo JHtml::_('sliders.end'); ?>
				</div>
			<?php endif ?>
		</div>
		<div class="clr"></div>
		
		<input type="hidden" name="task" value="" /> 
		
		<?php echo $this->form->getInput('id'); ?>
		<?php echo $this->form->getInput('asset_id'); ?>
		<?php echo $this->form->getInput('archive_flag'); ?>
		<?php echo $this->form->getInput('archive_time'); ?>
		<?php echo JHTML::_('form.token'); ?>
	</form>

	<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
</div>