<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman single newsletter default 0 template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

JHTML::_('behavior.keepalive');

if (version_compare(JVERSION,'3.0.0','>=')) {
	JHtml::_('bootstrap.tooltip');
	$image = '<i class="icon-info"></i>';
}
else {
	JHTML::_('behavior.tooltip');
	$image = JHTML::_('image', 'administrator/templates/'. $this->template .'/images/menu/icon-16-info.png', JText::_('COM_BWPOSTMAN_NOTES'));
}
?>


<div class="form-horizontal">
	<fieldset class="adminform">
		<legend><?php echo JTEXT::_('COM_BWPOSTMAN_NL_GENERAL'); ?></legend>
		<div class="well well-small">
			<div class="width-50 fltlft span6 control-group">
				<ul class="adminformlist unstyled">
					<?php foreach($this->form->getFieldset('basic_1') as $field): ?>
						<?php if ($field->hidden): ?>
							<?php echo $field->input; ?>
						<?php else: ?>
							<li <?php echo 'class="' . $field->name  . '"'; ?>><?php echo $field->label; ?>
								<div class="controls"><?php echo $field->input; ?></div></li>
						<?php endif; ?>
					<?php endforeach; ?>
				</ul>
			</div>
				
			<div class="width-50 fltlft span6 control-group">
				<ul class="adminformlist unstyled">
					<?php foreach($this->form->getFieldset('basic_2') as $field): ?>
						<?php if ($field->hidden): ?>
							<li><?php echo $field->input; ?></li>
						<?php else: ?>
							<li <?php echo 'class="' . $field->name  . '"'; ?>><?php echo $field->label; ?>
								<div class="controls"><?php echo $field->input; ?></div></li>
						<?php endif; ?>
					<?php endforeach; ?>
				</ul>
			</div>
			<div class="clr clearfix"></div>
			<p><span class="required_description"><?php echo JText::_('COM_BWPOSTMAN_REQUIRED'); ?></span></p>
		</div>
	</fieldset>
</div>
<fieldset class="adminform">
	<legend><?php echo JTEXT::_('COM_BWPOSTMAN_NL_ASSIGNMENTS'); ?></legend>
	<div class="row-fluid form-horizontal">
		<div class="well well-small">
			<fieldset class="adminform">
				<legend><?php echo JTEXT::_('COM_BWPOSTMAN_NL_ASSIGNMENTS_CAMPAIGNS'); ?></legend>
				<?php foreach($this->form->getFieldset('campaigns') as $field): ?>
				<?php if ($field->hidden): ?>
					<?php echo $field->input; ?>
				<?php else: ?>
					<?php echo $field->label; ?>
					<?php if (version_compare(JVERSION,'3.0.0','<')) { echo '<div class="checkboxes">'; }
					if (!$this->item->campaign_id){ $checked = '-1'; } else { $checked = $this->item->campaign_id;}
						echo JHtmlSelect::radiolist($this->campaigns, 'jform[campaign_id]', 'class="inputbox" size="1"', 'value', 'text', $checked );
					if (version_compare(JVERSION,'3.0.0','<')) { echo '</div>'; } ?>
				<?php endif; ?>
			<?php endforeach; ?>
		</fieldset>
		</div>
	</div>
	<div class="clr clearfix"></div>

	<div class="row-fluid">
		<fieldset class="adminform">
			<legend><?php echo JTEXT::_('COM_BWPOSTMAN_NL_ASSIGNMENTS_RECIPIENTS'); ?></legend>
			<div class="width-75 fltlft span9">
				<div class="well well-small">
					<fieldset class="adminform">
					<legend>
						<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_NL_COM_BWPOSTMAN_MAILINGLISTS_NOTE'); ?>"><?php echo $image; ?></span>
						<span<?php if (version_compare(JVERSION,'3.0.0','<')) { echo ' class="legendlabel"'; } ?>>&nbsp;<?php echo JTEXT::_('COM_BWPOSTMAN_NL_COM_BWPOSTMAN_MAILINGLISTS'); ?></span>
					</legend>
					<?php foreach($this->form->getFieldset('mailinglists') as $field): ?>
						<?php if ($field->hidden): ?>
							<?php echo $field->input; // herein lies the warning, that htmlspecialchars()/parameter 1 has to be a string, but jform[mailinglists] and jform[usergroups] have to be arrays ?>
						<?php else: ?>
							<div class="width-33 fltlft span4">
								<div class="well well-small">
									<fieldset class="adminform">
										<legend>
											<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_($field->description); ?>"><?php echo $image; ?></span>
											<span<?php if (version_compare(JVERSION,'3.0.0','<')) { echo ' class="legendlabel"'; } ?>>&nbsp;<?php echo $field->label; ?></span>
										</legend>
										<div class="row-fluid clearfix">
											<?php
													$input_field	= trim($field->input); 
													if (!empty($input_field)) echo $field->input; 
													else echo '<div class="width-50 fltlft span6"><label class="mailinglist_label noclear checkbox">'. JText::_('COM_BWPOSTMAN_NO_DATA') .'</label></div>'; 
//													if (!empty(trim($field->input))) { echo $field->input; }
//                              						else { echo '<label class="mailinglist_label noclear checkbox">'. JText::_('COM_BWPOSTMAN_NO_DATA') .'</label>'; }
													?>
											</div>
										</fieldset>
                  					</div>
                  				</div>
                  				<?php endif; ?>
						<?php endforeach; ?>
					</fieldset>
				</div>
			</div>

			<div class="width-25 fltlft span3">
				<div class="well well-small">
					<fieldset class="adminform">
						<legend>
							<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_NL_FIELD_ACCESS_DESC'); ?>"><?php echo $image; ?></span>
							<span<?php if (version_compare(JVERSION,'3.0.0','<')) { echo ' class="legendlabel"'; } ?>>&nbsp;<?php echo JTEXT::_('COM_BWPOSTMAN_NL_FIELD_ACCESS_LABEL'); ?></span>
						</legend>
						<?php foreach($this->form->getFieldset('access') as $field): ?>
							<?php echo $field->input; ?>
						<?php endforeach; ?>
					</fieldset>
				</div>
			</div>
		</fieldset>
	</div>
	<div class="clr clearfix"></div>
	
	<div class="row-fluid">
		<div class="well well-small">
			<fieldset class="adminform">
				<legend>
					<span class="editlinktip hasTip hasTooltip" title="<?php echo JText::_('COM_BWPOSTMAN_NL_ADD_CONTENT_NOTE'); ?>"><?php echo $image; ?></span>
					<span<?php if (version_compare(JVERSION,'3.0.0','<')) { echo ' class="legendlabel"'; } ?>>&nbsp;<?php echo JTEXT::_('COM_BWPOSTMAN_NL_ASSIGNMENTS_CONTENTS'); ?></span>
				</legend>
				<div class="width-40 fltlft span4">
					<ul class="adminformlist unstyled">
						<?php foreach($this->form->getFieldset('selected_content') as $field): ?>
							<?php if ($field->hidden): ?>
								<li><?php echo $field->input; ?></li>
							<?php else: ?>
								<li <?php echo 'class="' . $field->name  . '"'; ?>><?php echo $field->label; ?>
									<?php echo $field->input; ?></li>
							<?php endif; ?>
						<?php endforeach; ?>
					</ul>
				</div>

				<div class="width-20 fltlft span3">
					<input style="width: 50px" type="button" name="left" value="&lt;"
						onclick="moveSelectedOptions(document.adminForm['jform_available_content'], document.adminForm['jform_selected_content'])" />
					<input style="width: 50px" type="button" name="right" value="&gt;"
						onclick="moveSelectedOptions(document.adminForm['jform_selected_content'], document.adminForm['jform_available_content'])" />
				</div>
				
				<div class="width-40 fltlft span4">
					<ul class="adminformlist unstyled">
						<?php foreach($this->form->getFieldset('available_content') as $field): ?>
							<?php if ($field->hidden): ?>
								<li><?php echo $field->input; ?></li>
							<?php else: ?>
								<li <?php echo 'class="' . $field->name  . '"'; ?>><?php echo $field->label; ?>
									<?php echo $field->input; ?></li>
								<?php endif; ?>
						<?php endforeach; ?>
					</ul>
				</div>
			</fieldset>
		</div>
	</div>
</fieldset>
<div class="clr clearfix"></div>
<div class="well well-small">
	<?php 
	if ($this->canDo->get('core.admin')): ?>
		<div class="fltlft">
			<?php echo JHtml::_('sliders.start', 'permissions-sliders-'.$this->item->id, array('useCookie'=>1)); ?>
			<?php echo JHtml::_('sliders.panel', JText::_('COM_BWPOSTMAN_NL_FIELDSET_RULES'), 'access-rules'); ?>
			<fieldset class="panelform">
				<?php echo $this->form->getLabel('rules'); ?>
				<?php echo $this->form->getInput('rules'); ?>
			</fieldset>
			<?php echo JHtml::_('sliders.end'); ?>
		</div>
	<?php endif ?>
</div>
<div class="clr clearfix"></div>
