<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman single html newsletters view for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import VIEW object class
jimport('joomla.application.component.view');

// Require helper class
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/helper.php');

/**
 * BwPostman Newsletter View
 *
 * @package 	BwPostman-Admin
 * @subpackage 	Newsletters
 */
class BwPostmanViewNewsletter extends JViewLegacy
{
	protected $form;
	protected $item;
	protected $state;
	/**
	 * Display
	 *
	 * @access	public
	 * @param	string Template
	 */
	public function display($tpl=null)
	{
		$app		= JFactory::getApplication();
		$jinput		= JFactory::getApplication()->input;
		$_db		= JFactory::getDBO();
		$editor		= JFactory::getEditor();
		$uri		= JFactory::getURI();
		$cid		= $jinput->getInt('id', 0);
		$state_data	= $app->getUserState('com_bwpostman.edit.newsletter.data');

		//check for queue entries
		$this->queueEntries	= BwPostmanHelper::checkQueueEntries();

		if (is_array($state_data)) {
			$state_tmp = new stdClass();
			foreach ($state_data as $k => $v) {
					$state_tmp->$k = $v;
			}
			$state_data	= $state_tmp;
			$app->setUserState('com_bwpostman.edit.newsletter.data', $state_data);
		}
		
		if (is_null($state_data) || $state_data->id != $cid) {
			// Get the data from the model
			$this->item		= $this->get('Item');
		}
		else {
			$this->item		= $state_data;
		}
		$this->form		= $this->get('Form');
		$this->state	= $this->get('State');
		$this->canDo	= BwPostmanHelper::getActions($this->item->id, 'newsletter');
		$this->editor	= JFactory::getEditor();
		$this->template	= $app->getTemplate();
		$this->params	= JComponentHelper::getParams('com_bwpostman');
		
		if ($this->item->html_version || $this->item->text_version) {
			$this->content_exists = true;
		} else {
			$this->content_exists = false;
		}

		if (is_array($this->item->selected_content)) {
			$this->selected_content_old	= implode(',', $this->item->selected_content);
		}
		elseif (isset($this->item->selected_content)) {
			$this->selected_content_old	= $this->item->selected_content;
		}
		else {
			$this->selected_content_old	= '';
		}
		
//		$selected_campaign = $this->item->campaign_id;
		// Build the select list for the campaign assignement
		$query	= $_db->getQuery(true);
		$query->select($_db->quoteName('id')  . ' AS ' . $_db->quoteName('value'));
		$query->select($_db->quoteName('title')  . ' AS ' . $_db->quoteName('text'));
		$query->from($_db->quoteName('#__bwpostman_campaigns'));
		$query->where($_db->quoteName('archive_flag') . ' = ' . (int) 0);
		$query->group($_db->quoteName('title'));
		$query->order($_db->quoteName('title'));
		
		$_db->setQuery($query);
		
		$campaign_id[] = JHtml::_('select.option', '-1', ' - '. JText::_('COM_BWPOSTMAN_NL_SELECT_CAMPAIGN') .' -');

		$this->campaigns = array_merge($campaign_id, $_db->loadObjectList());
		
		// Get selected Usergroups
		$usergroups			= array();
		$this->usergroups	= array();
		
		if (is_array($this->item->usergroups)) {
			$this->usergroups	= $this->item->usergroups;
		}
		elseif ($this->item->id) {
			$query	= $_db->getQuery(true);
			$query->select($_db->quoteName('mailinglist_id')  . ' AS ' . $_db->Quote('usergroup'));
			$query->from($_db->quoteName('#__bwpostman_newsletters_mailinglists'));
			$query->where($_db->quoteName('newsletter_id') . ' = ' . (int) $this->item->id);
			$query->where($_db->quoteName('mailinglist_id') . ' < ' . (int) 0);
		
			$_db->setQuery($query);
		
			$usergroups	= $_db->loadColumn();
			foreach ($usergroups as $value) $this->usergroups[]	= -(int)$value;
		} 

		$this->addToolbar();
		// reset temporary state
		$app->setUserState('com_bwpostman.edit.newsletter.changeTab', false);
		
		// Call parent display
		parent::display($tpl);
	}
			
	/**
	 * Add the page title, styles and toolbar.
	 *
	 */
	protected function addToolbar()
	{
		JFactory::getApplication()->input->set('hidemainmenu', true);
		$uri		= JFactory::getURI();
		$userId		= JFactory::getUser()->get('id');
		
		// Get document object, set document title and add css
		$document	= JFactory::getDocument();
		$document->setTitle('COM_BWPOSTMAN_NL_DETAILS');
		$document->addStyleSheet('components/com_bwpostman/assets/css/bwpostman_backend.css');
		$document->addScript(JURI::base().'components/com_bwpostman/assets/js/bwpostman.js');
		
		// Set toolbar title and items
		$canDo			= BwPostmanHelper::getActions($this->item->id, 'newsletter');
		$checkedOut		= !($this->item->checked_out == 0 || $this->item->checked_out == $userId);
		$this->canDo	= $canDo;
		
		$isNew = ($this->item->id == 0);

		// For new records, check the create permission.
		if ($isNew && $canDo->get('core.create')) {
			JToolBarHelper::save('newsletter.save');
			JToolBarHelper::apply('newsletter.apply');
			JToolBarHelper::cancel('newsletter.cancel');
			if (version_compare(JVERSION,'3.0.0','>=')) {
				JToolBarHelper::title(JText::_('COM_BWPOSTMAN_NL_DETAILS').': <small>[ ' . JText::_('NEW').' ]</small>', 'plus');
			}
			else {
				JToolBarHelper::title(JText::_('COM_BWPOSTMAN_NL_DETAILS').': <small>[ ' . JText::_('NEW').' ]</small>', 'newsletteradd');
			}
		}
		else {
			// Can't save the record if it's checked out.
			if (!$checkedOut) {
				// Since it's an existing record, check the edit permission, or fall back to edit own if the owner.
				if ($canDo->get('core.edit') || ($canDo->get('core.edit.own') && $this->item->created_by == $userId)) {
					JToolBarHelper::save('newsletter.save');
					JToolBarHelper::apply('newsletter.apply');
				}
			}
			// Rename the cancel button for existing items
			JToolBarHelper::cancel('newsletter.cancel', 'COM_BWPOSTMAN_CLOSE');
			if (version_compare(JVERSION,'3.0.0','>=')) {
				JToolBarHelper::title(JText::_('COM_BWPOSTMAN_NL_DETAILS').': <small>[ ' . JText::_('EDIT').' ]</small>', 'edit');
			}
			else {
				JToolBarHelper::title(JText::_('COM_BWPOSTMAN_NL_DETAILS').': <small>[ ' . JText::_('EDIT').' ]</small>', 'newsletteredit');
			}
			JToolBarHelper::title(JText::_('COM_BWPOSTMAN_NL_DETAILS').': <small>[ ' . JText::_('EDIT').' ]</small>', 'newsletteredit');
		}
/*		JToolBarHelper::spacer();
		JToolBarHelper::divider();
		JToolBarHelper::spacer();
		if (version_compare(JVERSION,'3.0.0','>=')) {
			if ($canDo->get('core.create') || $canDo->get('core.edit') || $canDo->get('core.send')) JToolBarHelper::custom('newsletter.checkForm', 'thumbs-up', 'checkform_f2', 'COM_BWPOSTMAN_NL_CHECK_FORM', false);
		}
		else {
			if ($canDo->get('core.create') || $canDo->get('core.edit') || $canDo->get('core.send')) JToolBarHelper::custom('newsletter.checkForm', 'checkform', 'checkform_f2', 'COM_BWPOSTMAN_NL_CHECK_FORM', false);
		}
*/			
		$backlink	= $uri->toString();
		$siteURL 	= $uri->base();

		// If we came from the main page we will show a back button
		// We have to modify the back button because if we click on 'back' we have to delete the entry from the newsletters_tmp-table
		// which will be generated everytime we click on add/edit
		if ($backlink == $siteURL.'index.php?option=com_bwpostman') {
			JToolBarHelper::spacer();
			JToolBarHelper::divider();
			JToolBarHelper::spacer();
			JToolBarHelper::custom('newsletter.back', 'back.png', 'back_f2.png', JText::_('BACK'), false);
		}
		JToolBarHelper::divider();
		JToolBarHelper::spacer();
		JToolBarHelper::help(JText::_("COM_BWPOSTMAN_FORUM"), false, 'http://www.boldt-webservice.de/forum/bwpostman.html');
		JToolBarHelper::spacer();
	}
}