<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman single text (raw) newsletters view for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import VIEW object class
jimport('joomla.application.component.view');

/**
 * BwPostman Newsletter RAW View
 *
 * @package 	BwPostman-Admin
 * @subpackage 	Newsletters
 */
class BwPostmanViewNewsletter extends JViewLegacy
{
	public function display ($tpl = Null)
	{
		$app 	= JFactory::getApplication();
		$jinput	= JFactory::getApplication()->input;

		// Get the params because they contain the css for the html-newsletters
		$params			= JComponentHelper::getParams('com_bwpostman');
		$mails_per_step	= $app->getUserState('com_bwpostman.newsletters.mails_per_pageload', $params->get('default_mails_per_pageload'));

		$model	= $this->getModel('newsletter');
		$task	= $jinput->get('task', 'previewHTML');
		$nl_id	= $jinput->get('nl_id');
		
		if ($task == 'continue_sending'){
			if ($model->checkTrials(2)) {
				$ret = $model->_sendMailsFromQueue($mails_per_step);
				if ($ret == 1){   // There are more mails in the queue.
					echo '<script type="text/javascript">'."\n";
					echo "window.location.reload(); \n";
					echo "</script>\n";
				}
				if ($ret == 0){   // No more mails to send.
					echo JText::_('COM_BWPOSTMAN_NL_QUEUE_COMPLETED'); ob_flush();flush();
					echo '<script type="text/javascript">'."\n";
					// We cannot replace the "&" with an "&amp;" because it's JavaScript and not HTML
					echo "function goBackToQueue(){window.parent.location.href = 'index.php?option=com_bwpostman&view=newsletters&layout=queue';} \n";
					echo "setTimeout('goBackToQueue()',5000); \n";
					echo "</script>\n";
				}
			}
			else {
				echo JText::_('COM_BWPOSTMAN_NL_SENDING_NO_QUEUE_ENTRIES_TO_SEND');
			}
		}
		elseif ($task == 'insideModal') {
			// Get the newsletter 
			$this->item	= $model->getItem($nl_id);
			$this->item	= $model->getSingleNewsletter();
		} 
		else {
			// Get the newsletter 
			$this->item	= $model->getSingleNewsletter();
		}
		// Call parent display
		parent::display($tpl);
	}
}