<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman backend element template to select a singlenewsletter for a view in frontend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

JHtml::_('behavior.tooltip');
?>

<form action="index.php?option=com_bwpostman&amp;view=newsletterelement&amp;tmpl=component" method="post" name="adminForm">

	<table class="adminform">
		<tr>
			<td width="100%">
				<?php echo JText::_('JSEARCH_FILTER_LABEL'); ?>
				<input type="text" name="search" id="search" value="<?php echo $this->lists['search']; ?>" class="text_area" onChange="document.adminForm.submit();" />
				<?php	if (version_compare(JVERSION,'3.0.0','>=')) { ?>
					<button onclick="this.form.submit();" class="btn hasTooltip" title="<?php echo JHtml::tooltipText('JSEARCH_FILTER_SUBMIT'); ?>" data-placement="bottom" style="margin-bottom:9px;">
						<span class="icon-search"></span><?php echo '&#160;' . JText::_('JSEARCH_FILTER_SUBMIT'); ?>
					</button>
					<button type="button" class="btn hasTooltip" title="<?php echo JHtml::tooltipText('JSEARCH_FILTER_CLEAR'); ?>" data-placement="bottom" onclick="this.form.getElementById('search').setAttribute('value', '');this.form.submit();" style="margin-bottom:9px;">
						<span class="icon-remove"></span><?php echo '&#160;' . JText::_('JSEARCH_FILTER_CLEAR'); ?>
					</button>
				<?php }
				else  { ?>
					<button onclick="this.form.submit();"><?php echo JText::_( 'GO' ); ?></button>
					<button onclick="this.form.getElementById('search').setAttribute('value', '');this.form.submit();"><?php echo JText::_( 'RESET' ); ?></button>
				<?php	} ?>
			</td>
			<td nowrap="nowrap">
				<?php	if (version_compare(JVERSION,'3.0.0','>=')) { ?>
        		<select id="filter_state" class="inputbox" onchange="this.form.submit()" size="1" name="filter_state">
        	<?php }
        	else  { ?>
        		<select id="filter_state" class="inputbox" onchange="Joomla.submitform();" size="1" name="filter_state">
        	<?php } ?>
					<option <?php	if ($this->filter_state == '') echo 'selected="selected" ' ?>value="">- Status auswählen -</option>
					<option <?php	if ($this->filter_state == 'P') echo 'selected="selected" ' ?>value="P">veröffentlicht</option>
					<option <?php	if ($this->filter_state == 'U') echo 'selected="selected" ' ?>value="U">unveröffentlicht</option>
        		</select>
        	</td>
		</tr>
	</table>
  <br />	
	
	<table class="adminlist table">
		<thead>
			<tr>
				<th width="5"><?php echo JHTML::_('grid.sort', 'ID', 'a.id', $this->lists['order_Dir'], $this->lists['order'], 'newsletterelement' ); ?></th>
				<th class="title"><?php echo JHTML::_('grid.sort', 'Subject', 'a.subject', $this->lists['order_Dir'], $this->lists['order'], 'newsletterelement' ); ?></th>
				<th class="title"><?php echo JHTML::_('grid.sort', 'COM_BWPOSTMAN_NL_MAILING_DATE', 'a.mailing_date', $this->lists['order_Dir'], $this->lists['order'], 'newsletterelement' ); ?></th>
				<th class="title"><?php echo JHTML::_('grid.sort', 'Published', 'a.published', $this->lists['order_Dir'], $this->lists['order'], 'newsletterelement' ); ?></th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="8">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
			<?php foreach ($this->items as $i => $item) : ?>
				<tr class="row<?php echo $i % 2; ?>">
					<td align="center"><?php echo $item->id; ?></td>
					<td>  
						<span class="editlinktip hasTip" title="<?php echo JText::_( 'COM_BWPOSTMAN_SELECT_NEWSLETTER' );?>::<?php echo $item->subject; ?>">
							<a style="cursor:pointer" onclick="window.parent.SelectNewsletter('<?php echo $item->id; ?>', '<?php echo str_replace( array("'", "\""), array("\\'", ""), $item->subject ); ?>');">
								<?php echo htmlspecialchars($item->subject, ENT_QUOTES, 'UTF-8'); ?>
							</a>
						</span>
					</td>
					<td align="center"><?php echo $item->mailing_date; ?></td>
					<td align="center"><?php echo JHTML::_('grid.published', $item, $i); ?></td>
				</tr>
				<?php endforeach; ?>
		</tbody>
	</table>
	
	<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
	
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="filter_order" value="<?php echo $this->lists['order']; ?>" />
	<input type="hidden" name="filter_order_Dir" value="" />
	<?php echo JHTML::_('form.token'); ?>
</form>