<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman all newsletters sent template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');
JHTML::_('behavior.modal');
JHtml::_('behavior.multiselect');

// Require helper class
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/htmlhelper.php');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
?>

<script type="text/javascript">
	Joomla.checkAll2 = function(checkbox, stub) {
	    if (!stub) {
	        stub = 'ub';
	    }
	    if (checkbox.form) {
	        var c = 0, i, e;
	        for (i = 0, n = checkbox.form.elements.length; i < n; i++) {
	            e = checkbox.form.elements[i];
	            if (e.type == checkbox.type) {
	                if ((stub && e.id.indexOf(stub) == 0) || !stub) {
	                    e.checked = checkbox.checked;
	                    c += (e.checked == true ? 1 : 0);
	                }
	            }
	        }
	        if (checkbox.form.boxchecked) {
	            checkbox.form.boxchecked.value = c;
	        }
	        return true;
	    }
	    return false;
	}
</script> 

<div class="row-fluid">
	<table class="adminlist table table-striped">
		<thead>
			<tr>
				<th width="30" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'NUM', 'a.id', $listDirn, $listOrder); ?></th>
				<th width="30" nowrap="nowrap" align="center"><input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll2(this)" /></th>
				<th nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_SUBJECT', 'a.subject', $listDirn, $listOrder); ?></th>
				<th nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?></th>
				<th width="150" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_MAILING_DATE', 'a.mailing_date', $listDirn, $listOrder); ?></th>
				<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort', 'COM_BWPOSTMAN_NL_AUTHOR', 'author', $listDirn, $listOrder); ?></th>
				<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_CAM_NAME', 'campaign', $listDirn, $listOrder); ?></th>
				<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'Published', 'a.published', $listDirn, $listOrder); ?></th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if (count($this->items)) {
				foreach ($this->items as $i => $item) : 
					$canCheckin	= $user->authorise('core.manage',		'com_bwpostman') || $item->checked_out == $userId || $item->checked_out == 0;
					$canChange	= $user->authorise('core.edit.state',	'com_bwpostman.newsletter.'.$item->id) && $canCheckin;
					?>
					<tr class="row<?php echo $i % 2; ?>">
						<td align="center"><?php echo $item->id; ?></td>
						<td align="center"><?php echo BwPostmanHTMLHelper::id($i, $item->id, $item->checked_out, 'cid', 'ub'); ?></td>
						<td>
							<?php if ($item->checked_out) echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'newsletters.', $canCheckin); ?>
							<?php echo $this->escape($item->subject); ?>
							<span class="editlinktip hasTip" title="<?php echo JText::_('COM_BWPOSTMAN_NL_SHOW_HTML');?>::<?php echo $this->escape($item->subject); ?>">
								<a class="modal" href="<?php echo JRoute::_('index.php?option=com_bwpostman&view=newsletter&format=raw&layout=newsletter_html_modal&task=insideModal&nl_id='. $item->id);?>" rel="{handler: 'iframe', size: {x: 650, y: 450}}"><?php echo JText::_('COM_BWPOSTMAN_HTML_NL');?></a>&nbsp;
							</span>
							<span class="editlinktip hasTip" title="<?php echo JText::_('COM_BWPOSTMAN_NL_SHOW_TEXT');?>::<?php echo $this->escape($item->subject); ?>">
								<a class="modal" href="<?php echo JRoute::_('index.php?option=com_bwpostman&view=newsletter&format=raw&layout=newsletter_text_modal&task=insideModal&nl_id='. $item->id);?>" rel="{handler: 'iframe', size: {x: 650, y: 450}}"><?php echo JText::_('COM_BWPOSTMAN_TEXT_NL');?></a>&nbsp;
							</span>
						</td>
						<td><?php echo $this->escape($item->description); ?></td>
						<td><?php echo JHtml::date($item->mailing_date, JText::_('BW_DATE_FORMAT_LC5')); ?></td>
						<td><?php echo $item->author; ?></td>
						<td align="center"><?php echo $item->campaign; ?></td>
						<td align="center"><?php echo JHtml::_('jgrid.published', $item->published, $i, 'newsletters.', $canChange, 'ub'); ?></td>
					</tr><?php
				endforeach;
			}
			else {
    		// if no data ?>
				<tr class="row1">
					<td colspan="8"><strong><?php echo JText::_('COM_BWPOSTMAN_NO_DATA'); ?></strong></td>
				</tr><?php
			}
		?>
		</tbody>
	</table>
</div>
<input type="hidden" name="tab" value="sent" />
