<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman all newsletters unsent template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

// To Convert the modified date to local user time for display in the form.
jimport('joomla.utilities.date');
$tz = $user->getParam('timezone', 'UTC');

?>

<div class="row-fluid">
	<table class="adminlist table table-striped">
		<thead>
			<tr>
				<th width="30" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'NUM', 'a.id', $listDirn, $listOrder); ?></th>
				<th width="30" nowrap="nowrap" align="center"><input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" /></th>
				<th nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_SUBJECT', 'a.subject', $listDirn, $listOrder); ?></th>
				<th nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_DESCRIPTION', 'a.description', $listDirn, $listOrder); ?></th>
				<th width="150" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_NL_LAST_MODIFICATION_DATE', 'a.modified_time', $listDirn, $listOrder); ?></th>
				<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort', 'COM_BWPOSTMAN_NL_AUTHOR', 'author', $listDirn, $listOrder); ?></th>
				<th width="100" nowrap="nowrap"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_CAM_NAME', 'campaign', $listDirn, $listOrder); ?></th>
			</tr>
		</thead>
		<tbody>
		<?php 
			if (count($this->items)) {
				foreach ($this->items as $i => $item) : 
					$canCheckin	= $user->authorise('core.manage',	'com_bwpostman') || $item->checked_out == $userId || $item->checked_out == 0;
					$canEdit	= $user->authorise('core.edit',		'com_bwpostman.newsletter.'.$item->id);
					$canEditOwn	= $user->authorise('core.edit.own',	'com_bwpostman.newsletter.'.$item->id) && $item->created_by == $userId;
					?>
					<tr class="row<?php echo $i % 2; ?>">
						<td align="center"><?php echo $item->id; ?></td>
						<td align="center"><?php echo JHtml::_('grid.id', $i, $item->id); ?></td>
						<td>
							<?php if ($item->checked_out) echo JHtml::_('jgrid.checkedout', $i, $item->editor, $item->checked_out_time, 'newsletters.', $canCheckin); ?>
							<?php if ($canEdit || $canEditOwn) : ?>
								<a href="<?php echo JRoute::_('index.php?option=com_bwpostman&task=newsletter.edit&id='. $item->id);?>">
									<?php echo $this->escape($item->subject); ?></a>
							<?php else : ?>
								<?php echo $this->escape($item->subject); ?>
							<?php endif; ?>
						</td>
						<td><?php echo $this->escape($item->description); ?></td>
						<td><?php  if ($item->modified_time != '0000-00-00 00:00:00')echo JHtml::date($item->modified_time, JText::_('BW_DATE_FORMAT_LC5')); ?></td>
						<td><?php echo $item->author; ?></td>
						<td align="center"><?php echo $item->campaign; ?></td>
					</tr><?php
				endforeach;
			}
			else {
    		// if no data ?>
				<tr class="row1">
					<td colspan="8"><strong><?php echo JText::_('COM_BWPOSTMAN_NO_DATA'); ?></strong></td>
				</tr><?php
			}
		?>
		</tbody>
	</table>
</div>
<input type="hidden" name="tab" value="unsent" />
