<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman all subscribers main template for backend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Admin
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

if (version_compare(JVERSION,'3.0.0','>=')) {
	JHtml::_('bootstrap.tooltip');
	JHtml::_('formbehavior.chosen', 'select');
	jimport ('joomla.html.html.bootstrap');
}
else {
	JHTML::_('behavior.tooltip');
	//Load tabs behavior for the Tabs
	//jimport('joomla.html.html.tabs');
	require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/bwtabs.php');
}

JHtml::_('behavior.multiselect');

//Load tabs behavior for the Tabs
require_once (JPATH_COMPONENT_ADMINISTRATOR.'/helpers/bwtabs.php');

$user		= JFactory::getUser();
$userId		= $user->get('id');
$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

$app	= JFactory::getApplication();
$tab	= $app->getUserState('com_bwpostman.subscribers.tab', 'confirmed');

switch ($tab) {
	default:
	case 'confirmed'		: $tab_offset	= 0;
		break;
	case 'unconfirmed'		: $tab_offset	= 1;
		break;
	case 'testrecipients'	: $tab_offset	= 2;
		break;
}
$tab_cookie	= false;

$tab_options = array(
		'onActive' => 'function(title, description){
        description.setStyle("display", "block");
        title.addClass("open").removeClass("closed");
    }',
		'onBackground' => 'function(title, description){
        description.setStyle("display", "none");
        title.addClass("closed").removeClass("open");
    }',
		'startOffset' => $tab_offset,  // 0 starts on the first tab, 1 starts the second, etc...
		'useCookie' => $tab_cookie, // note the quotes around true, since it must be a string. But if you put false there, you must not use qoutes otherwise JHtmlTabs will handle it as true
);
?>

<script type="text/javascript">
/* <![CDATA[ */
	Joomla.submitbutton = function (pressbutton) {
		
		if (pressbutton == 'archive') {
			ConfirmArchive = confirm("<?php echo JText::_('COM_BWPOSTMAN_SUB_CONFIRM_ARCHIVE' , true); ?>");
			if (ConfirmArchive == true) {
				submitform(pressbutton);
			} 
			else {
				return;
			}
		} 
		else {
			submitform(pressbutton);		
		} 
	}
/* ]]> */
</script>

<div id="bwp_view_lists">
	<form action="<?php echo JRoute::_('index.php?option=com_bwpostman&view=subscribers'); ?>" method="post" name="adminForm" id="adminForm" class="form-inline">
		<fieldset id="filter-bar" class="well well-small">
			<div class="filter-search fltlft pull-left">
				<label class="filter-search-lbl" for="filter_search"><?php echo JText::_('SEARCH'); ?></label>
				<select name="filter_search_filter" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->filtersearch, 'value', 'text', $this->state->get('filter.search_filter')) ; ?>
				</select>
				<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('COM_BWPOSTMAN_FILTER_SEARCH_DESC'); ?>" />
				
				<button type="submit" class="btn"><?php echo JText::_('JSEARCH_FILTER_SUBMIT'); ?></button>
				<button type="button" class="btn" onclick="document.getElementById('filter_search').value='';this.form.submit();"><?php echo JText::_('JSEARCH_FILTER_CLEAR'); ?></button>
			</div>
			<div class="filter-select fltrt pull-right">
				<select name="filter_mailinglist" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->mailinglists, 'value', 'text', $this->state->get('filter.mailinglist')) ; ?>
				</select>

				<select name="filter_emailformat" class="inputbox" onchange="this.form.submit()">
					<?php echo JHtml::_('select.options', $this->emailformat, 'value', 'text', $this->state->get('filter.emailformat')) ; ?>
				</select>
		        <?php
		        if (version_compare(JVERSION,'3.0.0','>=')) {
		          echo $this->pagination->getLimitBox();
				    }
		        ?>
			</div>
		</fieldset>
	
		<div class="row-fluid">
			<?php
				echo JHtmlBwTabs::start('bwpostman_subscribers_tabs', $tab_options);
				echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_SUB_CONFIRMED'), 'confirmed',
					"
						document.adminForm.getElementById('tab').setAttribute('value', 'confirmed');
						Joomla.submitbutton('subscribers.changeTab');
					");
				echo $this->loadTemplate('confirmed');
				echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_SUB_UNCONFIRMED'), 'unconfirmed',
					"
						document.adminForm.getElementById('tab').setAttribute('value', 'unconfirmed');
						Joomla.submitbutton('subscribers.changeTab');
					");
				echo $this->loadTemplate('unconfirmed');
				echo JHtmlBwTabs::panel(JText::_('COM_BWPOSTMAN_TEST'), 'testrecipients',
					"
						document.adminForm.getElementById('tab').setAttribute('value', 'testrecipients');
						Joomla.submitbutton('subscribers.changeTab');
					");
				echo $this->loadTemplate('testrecipients');
				echo JHtmlBwTabs::end();
			?>
		</div>
		<p class="pagination"><?php echo $this->pagination->getListFooter(); ?></p>
		<p class="copyright"><?php echo BwPostmanAdmin::footer(); ?></p>
		
		<?php //Load the batch processing form. ?>
		<?php if ($user->authorise('core.create', 'com_bwpostman') && $user->authorise('core.edit', 'com_bwpostman') && $user->authorise('core.edit.state', 'com_bwpostman')) : ?>
			<?php echo $this->loadTemplate('batch'); ?>
		<?php endif;?>
	
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" id="tab" name="tab" value="" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php $listDirn; ?>" />
		<?php echo JHTML::_('form.token'); ?>
	</form>
</div>