<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman newsletter single view for frontend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Site
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

// Import VIEW object class
jimport('joomla.application.component.view');

class BwPostmanViewNewsletter extends JViewLegacy
{
	/**
	 * Display
	 *
	 * @access	public
	 * @param 	string Template
	 */
	public function display($tpl = null)
	{
		$app	= JFactory::getApplication();
		$jinput	= JFactory::getApplication()->input;
		$id		= (int) $jinput->get('id', 0);
		$params	= $app->getPageParameters();

		// Get document object, set document title and add css
		$templateName	= $app->getTemplate();
//		$css_filename	= JPATH_BASE . '/templates/' . $templateName . '/css/com_bwpostman.css';
		$css_filename	= 'templates/' . $templateName . '/css/com_bwpostman.css';
		
		$document = JFactory::getDocument();
		$document->setTitle($params->get('page_title'));
		$document->addStyleSheet('components/com_bwpostman/assets/css/bwpostman.css');
		if (file_exists($css_filename)) $document->addStyleSheet($css_filename);
						
		// Count how often the newsletter has been viewed
		$newsletter = JTable::getInstance('newsletters', 'BwPostmanTable');
		$newsletter->load($id);
		$newsletter->hit($id);

		if ($newsletter->published == 0) {
			$app->enqueueMessage(JText::_('COM_BWPOSTMAN_ERROR_NL_NOT_AVAILABLE'), 'error');
		}

		// Setting the backlink
		$backlink = $_SERVER['HTTP_REFERER'];

		// Save a reference into the view
		$this->assignRef('backlink', $backlink);
		$this->assignRef('newsletter', $newsletter);
		$this->assignRef('params', $params);

		// Set parent display
		parent::display($tpl);
	}
}