<?php
/**
 * BwPostman Newsletter Component
 *
 * BwPostman newsletter all default template for frontend.
 *
 * @version 1.0.8.2 bwpm
 * @package BwPostman-Site
 * @author Romana Boldt
 * @copyright (C) 2012-2015 Boldt Webservice <forum@boldt-webservice.de>
 * @support http://www.boldt-webservice.de/forum/bwpostman.html
 * @license GNU/GPL, see LICENSE.txt
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

// Check to ensure this file is included in Joomla!
defined ('_JEXEC') or die ('Restricted access');

/**
 * BwPostman Newsletter Overview Layout
 *
 * @package 	BwPostman-Site
 * @subpackage 	Newsletters
 */

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

?>

<div id="bwp_com_nl_all">
	<?php if (($this->params->get('show_page_heading') != 0) && ($this->params->get('page_heading') != '')) : ?>
		<h1 class="componentheading<?php echo $this->params->get('pageclass_sfx'); ?>"><?php echo $this->escape($this->params->get('page_heading')); ?></h1>
	<?php endif; ?>
	
	<form action="<?php echo $this->uri; ?>" method="post" name="adminForm" id="adminForm">
		<div id="bwp_search<?php echo $this->params->get('pageclass_sfx'); ?>">
			<div class="search_left">
				<?php echo JText::_('COM_BWPOSTMAN_SEARCH'); ?> 
				<input type="text" name="filter_search" id="filter_search" value="<?php echo $this->escape($this->state->get('filter.search')); ?>" title="<?php echo JText::_('COM_BWPOSTMAN_FILTER_SEARCH_DESC'); ?>" />
				<button class="button go" onclick="document.getElementById('adminForm').submit();"><?php echo JText::_('COM_BWPOSTMAN_GO'); ?></button>
				<button type="button" class="button reset" onclick="document.getElementById('filter_search').setAttribute('value','');this.form.submit();"><?php echo JText::_('COM_BWPOSTMAN_RESET'); ?></button>
			</div>
			<div class="search_right">
				<?php echo JText::_('COM_BWPOSTMAN_DISPLAY_NUM').$this->pagination->getLimitBox(); ?>
			</div>
			<div class="clr"></div>
		</div>
	
		<table id="bwp_newsletters_table<?php echo $this->params->get('pageclass_sfx'); ?>">
			<thead>
				<tr>
					<th class="date_head"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_DATE', 'a.mailing_date', $listDirn, $listOrder); ?></th>
					<th class="subject_head"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_SUBJECT', 'a.subject', $listDirn, $listOrder); ?></th>
					<th class="clicks_head"><?php echo JHTML::_('grid.sort',  'COM_BWPOSTMAN_HITS', 'a.hits', $listDirn, $listOrder); ?></th>
				</tr>
			</thead>
			<tbody>
			<?php
				if (count($this->items) > 0) { 
					foreach ($this->items as $i => $item) : ?>
						<tr class="row<?php echo $i % 2; ?>">
							<td class="date"><?php $date = JHTML::Date($item->mailing_date, JText::_('DATE_FORMAT_LC3')); echo $date;?></td>
							<td class="subject"><a href="<?php echo JRoute::_("index.php?option=com_bwpostman&amp;view=newsletter&amp;id={$item->id}"); ?>"><?php echo $item->subject; ?></a></td>
							<td class="clicks"><?php echo $item->hits; ?></td>
						</tr>
					<?php
					endforeach; 
				}
				else { ?>
					<tr class="row0">
						<td colspan="3"><?php echo JText::_('COM_BWPOSTMAN_NO_NEWSLETTERS_FOUND');?></td>
				<?php } ?>
			</tbody>
		</table>
		
		<input type="hidden" name="option" value="com_bwpostman" /> 
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" /> 
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" /> 
		<input type="hidden" name="id" value="<?php //echo $this->items->id; ?>" />
		<?php echo JHTML::_('form.token'); ?>

		<p class="pagination_style_pages"><?php echo $this->pagination->getPagesLinks(); ?></p>
		<p class="pagination_style_counter"><?php echo $this->pagination->getPagesCounter(); ?></p>
	</form>
	
	<p class="copyright"><?php echo BwPostman::footer(); ?></p>
</div>